import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/advance_switch/custom_switch.dart';
import 'package:ovosale/app/components/alert-dialog/custom_alert_dialog.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/screens/warehouse/widgets/update_warehouse_pop_up.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/warehouse/warehouse_controller.dart';
import 'package:ovosale/data/model/warehouse/warehouse_response_model.dart';

import '../../../../core/app_permission/app_permission.dart';
import '../../../../data/controller/cart/global_controller.dart';

class WarehouseListTile extends StatelessWidget {
  final List<WarehouseData> warehouseData;
  final int index;
  const WarehouseListTile({
    super.key,
    required this.warehouseData,
    required this.index,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<WarehouseController>(
      builder: (controller) => ListTile(
          contentPadding: EdgeInsetsDirectional.zero,
          title: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(
                warehouseData[index].name.toString(),
                style: theme.textTheme.headlineSmall
                    ?.copyWith(fontSize: Dimensions.space16.sp),
              ),
              Row(
                children: [
                  MyAssetImageWidget(
                    assetPath: MyIcons.mobile,
                    isSvg: true,
                    height: Dimensions.space14.h,
                    width: Dimensions.space14.w,
                  ),
                  spaceSide(Dimensions.space4),
                  Expanded(
                    child: Text(
                      warehouseData[index].contactNumber.toString(),
                      style: theme.textTheme.labelSmall
                          ?.copyWith(fontWeight: FontWeight.w600),
                    ),
                  ),
                ],
              ),
              spaceDown(Dimensions.space4),
              Row(
                children: [
                  MyAssetImageWidget(
                    assetPath: MyIcons.address,
                    isSvg: true,
                    height: Dimensions.space14.h,
                    width: Dimensions.space14.w,
                  ),
                  spaceSide(Dimensions.space4),
                  Expanded(
                    child: Text(
                      [
                        warehouseData[index].address?.toString(),
                        warehouseData[index].city?.toString(),
                        warehouseData[index].state?.toString(),
                        warehouseData[index].postcode?.toString(),
                      ]
                          .where((element) =>
                              element != null && element.isNotEmpty)
                          .join(', '),
                      style: theme.textTheme.labelSmall
                          ?.copyWith(fontWeight: FontWeight.w600),
                    ),
                  ),
                ],
              ),
            ],
          ),
          trailing: Row(mainAxisSize: MainAxisSize.min, children: [
            CustomSwitch(
              isLoading: controller.warehouseUpdateLoadingIndex ==
                  controller.filteredWarehouseData[index].id,
              value: controller.filteredWarehouseData[index].status == "1"
                  ? true
                  : false,
              onChanged: (v) {
                controller.changeStatus(
                    controller.filteredWarehouseData[index].id.toString(),
                    index,
                    v);
              },
            ),
            spaceSide(Dimensions.space12),
            CustomAppCard(
                onPressed: () {
                  if (Get.find<GlobalController>().checkPermission(
                      featureName: AppPermissions.editWareHouse)) {
                    controller.getWarehouseFieldData(index);
                    CustomAlertDialog(
                      child: UpdateWarehousePopup(
                          warehouseId: warehouseData[index].id.toString()),
                    ).customAlertDialog(context);
                  }
                },
                showBorder: false,
                padding: EdgeInsetsDirectional.all(8),
                radius: Dimensions.space8,
                height: Dimensions.space32.h,
                width: Dimensions.space32.w,
                backgroundColor:
                    MyColor.getInformationColor().withValues(alpha: .2),
                child: MyAssetImageWidget(
                  assetPath: MyIcons.edit,
                  isSvg: true,
                  height: Dimensions.space10.h,
                  width: Dimensions.space16.w,
                )),
          ])),
    );
  }
}
