import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/warehouse/new_warehouse_controller.dart';
import 'package:ovosale/data/repo/new_warehouse/new_warehouse_repo.dart';

class NewWarehouseScreen extends StatefulWidget {
  const NewWarehouseScreen({super.key});

  @override
  State<NewWarehouseScreen> createState() => _NewWarehouseScreenState();
}

class _NewWarehouseScreenState extends State<NewWarehouseScreen> {
  @override
  void initState() {
    Get.put(NewWarehouseRepo());
    Get.put(NewWarehouseController(newWarehouseRepo: Get.find()));

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {});
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<NewWarehouseController>(
      builder: (controller) => MyCustomScaffold(
        padding: EdgeInsetsDirectional.zero,
        pageTitle: MyStrings.newWarehouse.tr,
        body: SingleChildScrollView(
          child: CustomAppCard(
              radius: 0,
              margin: EdgeInsetsDirectional.symmetric(
                  vertical: Dimensions.space10.h),
              showBorder: false,
              child: Column(children: [
                LabelTextField(
                  labelText: MyStrings.name.tr,
                  hintText: MyStrings.guardianFireSystem.tr,
                  isRequired: true,
                  controller: controller.warehouseNameController,
                  onChanged: (value) {},
                  contentPadding: EdgeInsetsDirectional.symmetric(
                      vertical: Dimensions.space17.h,
                      horizontal: Dimensions.space16.w),
                  textInputType: TextInputType.text,
                  textInputAction: TextInputAction.done,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space15.h),
                LabelTextField(
                  labelText: MyStrings.contactMobile.tr,
                  hintText: MyStrings.hintPhNumber.tr,
                  controller: controller.contactNumberController,
                  isRequired: true,
                  onChanged: (value) {},
                  contentPadding: EdgeInsetsDirectional.symmetric(
                      vertical: Dimensions.space17.h,
                      horizontal: Dimensions.space16.w),
                  textInputType: TextInputType.number,
                  textInputAction: TextInputAction.done,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space15.h),
                LabelTextField(
                  labelText: MyStrings.address.tr,
                  controller: controller.addressController,
                  maxLines: 5,
                  isRequired: true,
                  onChanged: (value) {},
                  contentPadding: EdgeInsetsDirectional.symmetric(
                      vertical: Dimensions.space17.h,
                      horizontal: Dimensions.space16.w),
                  textInputType: TextInputType.text,
                  textInputAction: TextInputAction.done,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space15.h),
                LabelTextField(
                  labelText: MyStrings.city.tr,
                  controller: controller.cityController,
                  onChanged: (value) {},
                  isRequired: true,
                  contentPadding: EdgeInsetsDirectional.symmetric(
                      vertical: Dimensions.space17.h,
                      horizontal: Dimensions.space16.w),
                  textInputType: TextInputType.text,
                  textInputAction: TextInputAction.done,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space15.h),
                LabelTextField(
                  labelText: MyStrings.state.tr,
                  controller: controller.stateController,
                  onChanged: (value) {},
                  contentPadding: EdgeInsetsDirectional.symmetric(
                      vertical: Dimensions.space17.h,
                      horizontal: Dimensions.space16.w),
                  textInputType: TextInputType.text,
                  textInputAction: TextInputAction.done,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space15.h),
                LabelTextField(
                  labelText: MyStrings.postCode.tr,
                  controller: controller.postCodeController,
                  onChanged: (value) {},
                  contentPadding: EdgeInsetsDirectional.symmetric(
                      vertical: Dimensions.space17.h,
                      horizontal: Dimensions.space16.w),
                  textInputType: TextInputType.text,
                  textInputAction: TextInputAction.done,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space15.h),
                CustomElevatedBtn(
                  isLoading: controller.isSubmitting,
                  text: MyStrings.save.tr,
                  onTap: () {
                    if (controller.warehouseNameController.text != "") {
                      if (controller.contactNumberController.text != "") {
                        if (controller.addressController.text != "") {
                          if (controller.cityController.text != "") {
                            controller.createWarehouse();
                          } else {
                            CustomSnackBar.error(
                                errorList: [MyStrings.cityNameisRequired.tr]);
                          }
                        } else {
                          CustomSnackBar.error(
                              errorList: [MyStrings.addressisRequired.tr]);
                        }
                      } else {
                        CustomSnackBar.error(errorList: [
                          MyStrings.warehouseContactisRequired.tr
                        ]);
                      }
                    } else {
                      CustomSnackBar.error(
                          errorList: [MyStrings.warehouseNameisRequired.tr]);
                    }
                  },
                  height: Dimensions.space56.h,
                  radius: Dimensions.largeRadius,
                ),
              ])),
        ),
      ),
    );
  }
}
