import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/advance_switch/custom_switch.dart';
import 'package:ovosale/app/components/alert-dialog/custom_alert_dialog.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/screens/variant/widgets/varinat_update_popup.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/variant/variant_controller.dart';

import '../../../../core/app_permission/app_permission.dart';
import '../../../../data/controller/cart/global_controller.dart';

class VariantScreenListTile extends StatelessWidget {
  final int index;
  const VariantScreenListTile({
    super.key,
    required this.index,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<VariantController>(
      builder: (controller) => ListTile(
          contentPadding: EdgeInsetsDirectional.zero,
          title: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(
                controller.filteredVariantDataList[index].name.toString(),
                style: theme.textTheme.headlineSmall
                    ?.copyWith(fontSize: Dimensions.space16.sp),
              ),
              spaceDown(Dimensions.space5),
              Text(
                controller.filteredVariantDataList[index].attribute?.name
                        .toString() ??
                    "",
                style: theme.textTheme.bodySmall
                    ?.copyWith(fontWeight: FontWeight.w600),
              ),
            ],
          ),
          trailing: Row(mainAxisSize: MainAxisSize.min, children: [
            CustomSwitch(
              isLoading: controller.attributeUpdateLoadingIndex ==
                  controller.filteredVariantDataList[index].id,
              value: controller.filteredVariantDataList[index].status == "1"
                  ? true
                  : false,
              onChanged: (v) {
                controller.changeStatus(
                    controller.filteredVariantDataList[index].id.toString(),
                    index,
                    v);
              },
            ),
            spaceSide(Dimensions.space12),
            CustomAppCard(
              onPressed: () {
                if (Get.find<GlobalController>()
                    .checkPermission(featureName: AppPermissions.editVariant)) {
                  controller.getSelectedItemValue(controller
                          .filteredVariantDataList[index].attribute?.id
                          .toString() ??
                      "0");
                  controller.methodNameController.text =
                      controller.filteredVariantDataList[index].name.toString();
                  CustomAlertDialog(
                    child: EditVariantPopup(
                      attributeId: controller
                              .filteredVariantDataList[index].attribute?.id
                              .toString() ??
                          "",
                      variantId: controller.filteredVariantDataList[index].id
                          .toString(),
                    ),
                  ).customAlertDialog(context);
                }
              },
              showBorder: false,
              padding: EdgeInsetsDirectional.all(Dimensions.space8),
              radius: Dimensions.space8,
              height: Dimensions.space32.h,
              width: Dimensions.space32.w,
              backgroundColor:
                  MyColor.getInformationColor().withValues(alpha: .2),
              child: MyAssetImageWidget(
                assetPath: MyIcons.edit,
                isSvg: true,
                height: Dimensions.space10.h,
                width: Dimensions.space16.w,
              ),
            ),
          ])),
    );
  }
}
