import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/custom_loader/custom_loader.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/app/components/text-field/custom_drop_down_text_field.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/variant/new_variant_controller.dart';
import 'package:ovosale/data/repo/new_variant/new_variant_repo.dart';

class NewVariantScreen extends StatefulWidget {
  const NewVariantScreen({super.key});

  @override
  State<NewVariantScreen> createState() => _NewVariantScreenState();
}

class _NewVariantScreenState extends State<NewVariantScreen> {
  @override
  void initState() {
    Get.put(NewVariantRepo());
    final controller =
        Get.put(NewVariantController(newVariantRepo: Get.find()));
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.getAttributes();
    });
  }

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<NewVariantController>(
      builder: (controller) => MyCustomScaffold(
        padding: EdgeInsetsDirectional.zero,
        pageTitle: MyStrings.newVariant.tr,
        body: controller.isLoading
            ? CustomLoader()
            : SingleChildScrollView(
                child: CustomAppCard(
                    radius: 0,
                    margin: EdgeInsetsDirectional.symmetric(
                        vertical: Dimensions.space10.h),
                    showBorder: false,
                    child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          LabelTextField(
                            controller: controller.variantNameController,
                            labelText: MyStrings.variantName.tr,
                            hintText: MyStrings.hintCategory.tr,
                            isRequired: true,
                            onChanged: (value) {},
                            contentPadding: EdgeInsetsDirectional.symmetric(
                                vertical: Dimensions.space17.h,
                                horizontal: Dimensions.space16.w),
                            textInputType: TextInputType.text,
                            textInputAction: TextInputAction.done,
                            radius: Dimensions.largeRadius,
                            validator: (value) {
                              if (value!.isEmpty) {
                                return MyStrings.fieldErrorMsg.tr;
                              } else {
                                return null;
                              }
                            },
                          ),
                          spaceDown(Dimensions.space30.h),
                          CustomDropDownTextField(
                            selectedValue:
                                controller.selectedValue, // Bind selected value
                            onChanged: (value) {
                              final selectedAttribute =
                                  controller.categoryDataList.firstWhere(
                                (attribute) => attribute.name == value,
                              );
                              controller.selectedValue = value;
                              controller.categoryId =
                                  selectedAttribute.id ?? "";
                              controller.update();
                            },
                            labelText: MyStrings.attribute.tr,
                            items: controller.categoryDataList.map((variant) {
                              return DropdownMenuItem<String>(
                                value: variant.name,
                                child: Text(
                                  variant.name ?? 'Unknown',
                                  style: theme.textTheme.bodyMedium,
                                ),
                              );
                            }).toList(),
                          ),
                          spaceDown(Dimensions.space25.h),
                          CustomElevatedBtn(
                            isLoading: controller.submitLoading,
                            text: MyStrings.save.tr,
                            onTap: () {
                              if (controller.variantNameController.text != "") {
                                if (controller.categoryId != "") {
                                  controller.createVariant();
                                } else {
                                  CustomSnackBar.error(errorList: [
                                    MyStrings.categoryNameIsRequired.tr
                                  ]);
                                }
                              } else {
                                CustomSnackBar.error(errorList: [
                                  MyStrings.variantNameisRequired.tr
                                ]);
                              }
                            },
                            height: Dimensions.space56.h,
                            radius: Dimensions.largeRadius,
                          ),
                        ])),
              ),
      ),
    );
  }
}
