import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/advance_switch/custom_switch.dart';
import 'package:ovosale/app/components/alert-dialog/custom_alert_dialog.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/screens/unit/widgets/update_unit_pop_up.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/unit/unit_controller.dart';

import '../../../../core/app_permission/app_permission.dart';
import '../../../../data/controller/cart/global_controller.dart';

class UnitListTile extends StatelessWidget {
  final int index;
  const UnitListTile({
    super.key,
    required this.index,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<UnitController>(
      builder: (controller) => ListTile(
          contentPadding: EdgeInsetsDirectional.zero,
          title: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(
                controller.filteredUnitDataList[index].name.toString(),
                style: theme.textTheme.headlineSmall
                    ?.copyWith(fontSize: Dimensions.space16.sp),
              ),
            ],
          ),
          trailing: Row(mainAxisSize: MainAxisSize.min, children: [
            CustomSwitch(
              isLoading: controller.warehouseUpdateLoadingIndex ==
                  controller.filteredUnitDataList[index].id,
              value: controller.filteredUnitDataList[index].status == "1"
                  ? true
                  : false,
              onChanged: (v) {
                controller.changeStatus(
                    controller.filteredUnitDataList[index].id.toString(),
                    index,
                    v);
              },
            ),
            spaceSide(Dimensions.space10),
            CustomAppCard(
                onPressed: () {
                  if (Get.find<GlobalController>()
                      .checkPermission(featureName: AppPermissions.editUnit)) {
                    controller.unitNameController.text =
                        controller.filteredUnitDataList[index].name.toString();
                    controller.unitShortNameController.text = controller
                        .filteredUnitDataList[index].shortName
                        .toString();
                    CustomAlertDialog(
                        child: UpdateUnitPopup(
                      index: index,
                    )).customAlertDialog(context);
                  }
                },
                showBorder: false,
                padding: EdgeInsetsDirectional.all(8),
                radius: Dimensions.space8,
                height: Dimensions.space32.h,
                width: Dimensions.space32.w,
                backgroundColor:
                    MyColor.getInformationColor().withValues(alpha: .2),
                child: MyAssetImageWidget(
                  assetPath: MyIcons.edit,
                  isSvg: true,
                  height: Dimensions.space10.h,
                  width: Dimensions.space16.w,
                )),
          ])),
    );
  }
}
