import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/unit/new_unit_controller.dart';
import 'package:ovosale/data/repo/unit/new_unit_repo.dart';

class NewUnitScreen extends StatefulWidget {
  const NewUnitScreen({super.key});

  @override
  State<NewUnitScreen> createState() => _NewUnitScreenState();
}

class _NewUnitScreenState extends State<NewUnitScreen> {
  @override
  void initState() {
    Get.put(NewUnitRepo());

    Get.put(NewUnitController(newUnitRepo: Get.find()));

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {});
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<NewUnitController>(
      builder: (controller) => MyCustomScaffold(
        padding: EdgeInsetsDirectional.zero,
        pageTitle: MyStrings.newUnit.tr,
        body: SingleChildScrollView(
          child: CustomAppCard(
              radius: 0,
              margin: EdgeInsetsDirectional.symmetric(
                  vertical: Dimensions.space10.h),
              showBorder: false,
              child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    LabelTextField(
                      labelText: MyStrings.unitName.tr,
                      controller: controller.unitNameController,
                      isRequired: true,
                      onChanged: (value) {},
                      contentPadding: EdgeInsetsDirectional.symmetric(
                          vertical: Dimensions.space17.h,
                          horizontal: Dimensions.space16.w),
                      textInputType: TextInputType.text,
                      textInputAction: TextInputAction.done,
                      radius: Dimensions.largeRadius,
                      validator: (value) {
                        if (value!.isEmpty) {
                          return MyStrings.fieldErrorMsg.tr;
                        } else {
                          return null;
                        }
                      },
                    ),
                    spaceDown(Dimensions.space10.h),
                    LabelTextField(
                      labelText: MyStrings.shortName.tr,
                      controller: controller.unitShortNameController,
                      isRequired: true,
                      onChanged: (value) {},
                      contentPadding: EdgeInsetsDirectional.symmetric(
                          vertical: Dimensions.space17.h,
                          horizontal: Dimensions.space16.w),
                      textInputType: TextInputType.text,
                      textInputAction: TextInputAction.done,
                      radius: Dimensions.largeRadius,
                      validator: (value) {
                        if (value!.isEmpty) {
                          return MyStrings.fieldErrorMsg.tr;
                        } else {
                          return null;
                        }
                      },
                    ),
                    spaceDown(Dimensions.space30.h),
                    CustomElevatedBtn(
                      isLoading: controller.submitLoading,
                      text: MyStrings.save.tr,
                      onTap: () {
                        if (controller.unitNameController.text != "") {
                          if (controller.unitShortNameController.text != "") {
                            controller.submitUnitData();
                          } else {
                            CustomSnackBar.error(errorList: [
                              MyStrings.unitShortNameisRequired.tr
                            ]);
                          }
                        } else {
                          CustomSnackBar.error(
                              errorList: [MyStrings.unitNameIsRequired.tr]);
                        }
                      },
                      height: Dimensions.space56.h,
                      radius: Dimensions.largeRadius,
                    ),
                  ])),
        ),
      ),
    );
  }
}
