import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/advance_switch/custom_switch.dart';
import 'package:ovosale/app/components/alert-dialog/custom_alert_dialog.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/screens/tax/widgets/update_tax_popup.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/tax/tax_controller.dart';
import 'package:ovosale/data/model/tax/tax_data_response_model.dart';
import '../../../../core/app_permission/app_permission.dart';
import '../../../../data/controller/cart/global_controller.dart';

class TaxListTile extends StatelessWidget {
  final List<TaxData> taxDataList;
  final int index;
  const TaxListTile({
    super.key,
    required this.taxDataList,
    required this.index,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<TaxController>(
      builder: (controller) => ListTile(
          contentPadding: EdgeInsetsDirectional.zero,
          title: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(
                taxDataList[index].name.toString(),
                style: theme.textTheme.headlineSmall
                    ?.copyWith(fontSize: Dimensions.space16.sp),
              ),
              Text(
                "${taxDataList[index].percentage.toString()}%",
                style: theme.textTheme.bodySmall
                    ?.copyWith(fontWeight: FontWeight.w600),
              ),
            ],
          ),
          trailing: Row(mainAxisSize: MainAxisSize.min, children: [
            CustomSwitch(
              isLoading: controller.taxUpdateLoadingIndex ==
                  controller.filteredTaxDataList[index].id,
              value: controller.filteredTaxDataList[index].status == "1"
                  ? true
                  : false,
              onChanged: (v) {
                controller.changeStatus(
                    controller.filteredTaxDataList[index].id.toString(),
                    index,
                    v);
              },
            ),
            spaceSide(Dimensions.space12),
            CustomAppCard(
              onPressed: () {
                if (Get.find<GlobalController>()
                    .checkPermission(featureName: AppPermissions.editTax)) {
                  controller.getSelectedItemValue(index);
                  controller.selectedTaxId =
                      controller.filteredTaxDataList[index].id.toString();
                  CustomAlertDialog(
                    child: UpdateTaxPopup(),
                  ).customAlertDialog(context);
                }
              },
              showBorder: false,
              padding: EdgeInsetsDirectional.all(Dimensions.space8),
              radius: Dimensions.space8,
              height: Dimensions.space32.h,
              width: Dimensions.space32.w,
              backgroundColor:
                  MyColor.getInformationColor().withValues(alpha: .2),
              child: MyAssetImageWidget(
                assetPath: MyIcons.edit,
                isSvg: true,
                height: Dimensions.space10.h,
                width: Dimensions.space16.w,
              ),
            ),
          ])),
    );
  }
}
