import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/tax/new_tax_controller.dart';
import 'package:ovosale/data/repo/tax/new_tax_repo.dart';

class NewTaxScreen extends StatefulWidget {
  const NewTaxScreen({super.key});

  @override
  State<NewTaxScreen> createState() => _NewTaxScreenState();
}

class _NewTaxScreenState extends State<NewTaxScreen> {
  @override
  void initState() {
    Get.put(NewTaxRepo());
    Get.put(NewTaxController(newTaxRepo: Get.find()));
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {});
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<NewTaxController>(
      builder: (controller) => MyCustomScaffold(
        padding: EdgeInsetsDirectional.zero,
        pageTitle: MyStrings.createNewTax.tr,
        body: SingleChildScrollView(
          child: CustomAppCard(
              radius: 0,
              margin: EdgeInsetsDirectional.symmetric(
                  vertical: Dimensions.space10.h),
              showBorder: false,
              child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    LabelTextField(
                      controller: controller.taxNameController,
                      labelText: MyStrings.name.tr,
                      isRequired: true,
                      onChanged: (value) {},
                      contentPadding: EdgeInsetsDirectional.symmetric(
                          vertical: Dimensions.space17.h,
                          horizontal: Dimensions.space16.w),
                      textInputType: TextInputType.text,
                      textInputAction: TextInputAction.done,
                      radius: Dimensions.largeRadius,
                      validator: (value) {
                        if (value!.isEmpty) {
                          return MyStrings.fieldErrorMsg.tr;
                        } else {
                          return null;
                        }
                      },
                    ),
                    spaceDown(Dimensions.space16.h),
                    LabelTextField(
                      controller: controller.percentController,
                      labelText: MyStrings.percentage.tr,
                      isRequired: true,
                      onChanged: (value) {},
                      contentPadding: EdgeInsetsDirectional.symmetric(
                          vertical: Dimensions.space17.h,
                          horizontal: Dimensions.space16.w),
                      textInputType: TextInputType.number,
                      textInputAction: TextInputAction.done,
                      radius: Dimensions.largeRadius,
                      validator: (value) {
                        if (value!.isEmpty) {
                          return MyStrings.fieldErrorMsg.tr;
                        } else {
                          return null;
                        }
                      },
                    ),
                    spaceDown(Dimensions.space16.h),
                    spaceDown(Dimensions.space25.h),
                    CustomElevatedBtn(
                      isLoading: controller.isSubmitting,
                      text: MyStrings.save.tr,
                      onTap: () {
                        if (controller.taxNameController.text != "") {
                          if (controller.percentController.text != "") {
                            controller.createNewTax();
                          } else {
                            CustomSnackBar.error(errorList: [
                              MyStrings.taxPercentageisRequired.tr
                            ]);
                          }
                        } else {
                          CustomSnackBar.error(
                              errorList: [MyStrings.taxNameIsRequired.tr]);
                        }
                      },
                      height: Dimensions.space56.h,
                      radius: Dimensions.largeRadius,
                    ),
                  ])),
        ),
      ),
    );
  }
}
