import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/alert-dialog/custom_alert_dialog.dart';
import 'package:ovosale/app/components/auto_grid_view/auto_height_grid_view.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_network_image_widget.dart';
import 'package:ovosale/app/screens/supplier_details/widgets/add_to_cart.dart';
import 'package:ovosale/core/utils/util_exporter.dart';

class SupplierAllProductSection extends StatelessWidget {
  const SupplierAllProductSection({super.key});

  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    ThemeData theme = Theme.of(context);
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Padding(
          padding: const EdgeInsets.all(Dimensions.space10),
          child: Text(
            MyStrings.allProducts.tr,
            style: theme.textTheme.headlineSmall,
          ),
        ),
        AutoHeightGridView(
            itemCount: 20,
            crossAxisCount: size.width > 500 ? 4 : 4,
            mainAxisSpacing: Dimensions.space8,
            crossAxisSpacing: 0,
            physics: const BouncingScrollPhysics(),
            padding: const EdgeInsets.all(0),
            shrinkWrap: true,
            // controller: scrollController,
            builder: (context, index) {
              return GestureDetector(
                onTap: () {
                  CustomAlertDialog(child: AddToCartPopup())
                      .customAlertDialog(context);
                },
                child: Column(
                  children: [
                    CustomAppCard(
                      height: Dimensions.space70.h,
                      width: Dimensions.space70.w,
                      padding: EdgeInsetsDirectional.all(Dimensions.space5),
                      backgroundColor: MyColor.white,
                      showBorder: true,
                      radius: 10,
                      child: MyNetworkImageWidget(
                        imageUrl:
                            "https://cdn.outsideonline.com/wp-content/uploads/2023/09/appe-15-camera_h.jpg?crop=16:9&width=960&enable=upscale&quality=100",
                        height: Dimensions.space60.h,
                        width: Dimensions.space60.w,
                        boxFit: BoxFit.cover,
                      ),
                    ),
                    spaceDown(Dimensions.space4),
                    Padding(
                      padding:
                          const EdgeInsetsDirectional.symmetric(horizontal: 6),
                      child: Text(
                        "Iphone 15Pro Max 256GB ",
                        textAlign: TextAlign.center,
                        style: theme.textTheme.bodySmall?.copyWith(
                          fontSize: Dimensions.space12.sp,
                        ),
                      ),
                    ),
                    spaceDown(Dimensions.space4),
                    Expanded(
                      child: Text(
                        "\$1149",
                        style: theme.textTheme.headlineSmall?.copyWith(
                            fontSize: Dimensions.space12.sp,
                            color: theme.primaryColor),
                      ),
                    ),
                  ],
                ),
              );
            }),
      ],
    );
  }
}
