import 'package:flutter/material.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/core/utils/util_exporter.dart';

class SupplierInfoSection extends StatelessWidget {
  final String productName;
  final String phoneNumber;
  final String email;
  final String address;
  const SupplierInfoSection(
      {super.key,
      required this.productName,
      required this.phoneNumber,
      required this.email,
      required this.address});

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return ListTile(
      contentPadding: EdgeInsetsDirectional.zero,
      title: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(
            productName,
            style: theme.textTheme.headlineSmall
                ?.copyWith(fontSize: Dimensions.space16.sp),
          ),
          Row(
            children: [
              MyAssetImageWidget(
                assetPath: MyIcons.mobile,
                isSvg: true,
                height: Dimensions.space14.h,
                width: Dimensions.space14.w,
              ),
              spaceSide(Dimensions.space4),
              Expanded(
                child: Text(
                  phoneNumber,
                  style: theme.textTheme.labelSmall
                      ?.copyWith(fontWeight: FontWeight.w600),
                ),
              ),
            ],
          ),
          spaceDown(Dimensions.space4),
          Row(
            children: [
              MyAssetImageWidget(
                assetPath: MyIcons.mail,
                isSvg: true,
                height: Dimensions.space14.h,
                width: Dimensions.space14.w,
              ),
              spaceSide(Dimensions.space4),
              Expanded(
                child: Text(
                  email,
                  style: theme.textTheme.labelSmall
                      ?.copyWith(fontWeight: FontWeight.w600),
                ),
              ),
            ],
          ),
          spaceDown(Dimensions.space4),
          Row(
            children: [
              MyAssetImageWidget(
                assetPath: MyIcons.address,
                isSvg: true,
                height: Dimensions.space14.h,
                width: Dimensions.space14.w,
              ),
              spaceSide(Dimensions.space4),
              Expanded(
                child: Text(
                  address,
                  style: theme.textTheme.labelSmall
                      ?.copyWith(fontWeight: FontWeight.w600),
                ),
              ),
            ],
          ),
        ],
      ),
    );
  }
}
