import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/image/my_network_image_widget.dart';
import 'package:ovosale/app/components/text-field/custom_drop_down_text_field.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/warehouse/new_warehouse_controller.dart';

class AddToCartPopup extends StatefulWidget {
  const AddToCartPopup({super.key});

  @override
  State<AddToCartPopup> createState() => _AddToCartPopupState();
}

class _AddToCartPopupState extends State<AddToCartPopup> {
  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<NewWarehouseController>(
      builder: (controller) => Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: Row(
              children: [
                CustomAppCard(
                    height: Dimensions.space56.h,
                    width: Dimensions.space56.w,
                    padding: EdgeInsetsDirectional.all(Dimensions.space4),
                    radius: Dimensions.space7,
                    child: MyNetworkImageWidget(
                        imageUrl:
                            "https://cdn.outsideonline.com/wp-content/uploads/2023/09/appe-15-camera_h.jpg?crop=16:9&width=960&enable=upscale&quality=100")),
                spaceSide(Dimensions.space4),
                Expanded(
                    child: Text("Iphone 15Pro Max",
                        style: theme.textTheme.headlineSmall)),
                GestureDetector(
                  onTap: () {
                    Get.back();
                  },
                  child: MyAssetImageWidget(
                    assetPath: MyIcons.popUpCancel,
                    height: Dimensions.space45.h,
                    width: Dimensions.space45.w,
                    isSvg: true,
                  ),
                )
              ],
            ),
          ),
          CustomDivider(),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: Column(
              children: [
                CustomDropDownTextField(
                  selectedValue: controller.selectedValue,
                  onChanged: (value) {
                    controller.selectedValue = value;
                    controller.update();
                  },
                  labelText: MyStrings.selectBrand.tr,
                  items: controller.dropdownData.map((item) {
                    return DropdownMenuItem(
                      value: item["label"],
                      child: Text(item["label"]!,
                          style: theme.textTheme.bodySmall),
                    );
                  }).toList(),
                ),
                spaceDown(Dimensions.space16.h),
                CustomDropDownTextField(
                  selectedValue: controller.selectedValue,
                  onChanged: (value) {
                    controller.selectedValue = value;
                    controller.update();
                  },
                  labelText: MyStrings.selectBrand.tr,
                  items: controller.dropdownData.map((item) {
                    return DropdownMenuItem(
                      value: item["label"],
                      child: Text(
                        item["label"]!,
                        style: theme.textTheme.bodySmall,
                      ),
                    );
                  }).toList(),
                ),
                spaceDown(Dimensions.space16.h),
                CustomDropDownTextField(
                  selectedValue: controller.selectedValue,
                  onChanged: (value) {
                    controller.selectedValue = value;
                    controller.update();
                  },
                  labelText: MyStrings.selectBrand.tr,
                  items: controller.dropdownData.map((item) {
                    return DropdownMenuItem(
                      value: item["label"],
                      child: Text(
                        item["label"]!,
                        style: theme.textTheme.bodySmall,
                      ),
                    );
                  }).toList(),
                ),
                spaceDown(Dimensions.space48.h),
                CustomElevatedBtn(
                  text: MyStrings.addtoCart.tr,
                  onTap: () {},
                  height: Dimensions.space56.h,
                  radius: Dimensions.largeRadius,
                ),
              ],
            ),
          ),
        ],
      ),
    );
  }
}
