import 'package:flutter/cupertino.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/screens/supplier_details/widgets/suplier_info_section.dart';
import 'package:ovosale/app/screens/supplier_details/widgets/supplier_all_products_section.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/supplier_details/supplier_details_controller.dart';
import 'package:ovosale/data/repo/supplier_details/supplier_details_repo.dart';

class SupplierDetailsScreen extends StatefulWidget {
  const SupplierDetailsScreen({super.key});

  @override
  State<SupplierDetailsScreen> createState() => _SupplierDetailsScreenState();
}

class _SupplierDetailsScreenState extends State<SupplierDetailsScreen> {
  @override
  void initState() {
    Get.put(SupplierDetailsRepo());
    Get.put(SupplierDetailsController(supplierDetailsRepo: Get.find()));
    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {});
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<SupplierDetailsController>(
        builder: (controller) => MyCustomScaffold(
              padding: EdgeInsetsDirectional.zero,
              pageTitle: MyStrings.supplierDetails.tr,
              body: SingleChildScrollView(
                child: Column(
                  children: [
                    spaceDown(Dimensions.space12),
                    CustomAppCard(
                      showBorder: false,
                      child: SupplierInfoSection(
                        productName: 'FlameWatch Installations',
                        phoneNumber: "(480) 555-0103",
                        email: "tienlapspktnd@gmail.com",
                        address: "8502 Preston Rd. Inglewood,",
                      ),
                    ),
                    spaceDown(Dimensions.space12),
                    CustomAppCard(
                        showBorder: false, child: SupplierAllProductSection()),
                    spaceDown(Dimensions.space100),
                  ],
                ),
              ),
            ));
  }
}
