import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/supplier/supplier_controller.dart';
import 'package:ovosale/data/model/supplier/supplier_response_model.dart';

class UpdateSupplierPopup extends StatefulWidget {
  final int index;
  final List<SuppliersData> couponDataList;
  const UpdateSupplierPopup({
    super.key,
    required this.index,
    required this.couponDataList,
  });

  @override
  State<UpdateSupplierPopup> createState() => _UpdateSupplierPopupState();
}

class _UpdateSupplierPopupState extends State<UpdateSupplierPopup> {
  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<SupplierController>(builder: (controller) {
      return Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: Row(
              children: [
                Expanded(
                    child: Text(MyStrings.updateSupplier.tr.toString(),
                        style: theme.textTheme.headlineSmall)),
                GestureDetector(
                  onTap: () {
                    Get.back();
                  },
                  child: MyAssetImageWidget(
                    assetPath: MyIcons.popUpCancel,
                    height: Dimensions.space45.h,
                    width: Dimensions.space45.w,
                    isSvg: true,
                  ),
                )
              ],
            ),
          ),
          CustomDivider(),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              isRequired: true,
              onChanged: () {},
              controller: controller.nameController,
              labelText: MyStrings.name.tr,
              textInputType: TextInputType.emailAddress,
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          spaceDown(Dimensions.space10),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              isRequired: true,
              onChanged: () {},
              controller: controller.companyNameController,
              labelText: MyStrings.companyName.tr,
              textInputType: TextInputType.emailAddress,
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          spaceDown(Dimensions.space10),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              onChanged: () {},
              controller: controller.emailController,
              labelText: MyStrings.email.tr,
              textInputType: TextInputType.emailAddress,
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          spaceDown(Dimensions.space10),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              isRequired: true,
              onChanged: () {},
              controller: controller.mobileController,
              labelText: MyStrings.phoneNumber.tr,
              textInputType: TextInputType.phone,
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          spaceDown(Dimensions.space10),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              onChanged: () {},
              controller: controller.addressController,
              labelText: MyStrings.address.tr,
              textInputType: TextInputType.phone,
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          spaceDown(Dimensions.space15.h),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              onChanged: () {},
              controller: controller.cityController,
              labelText: MyStrings.city.tr,
              textInputType: TextInputType.phone,
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          spaceDown(Dimensions.space15.h),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              onChanged: () {},
              controller: controller.stateController,
              labelText: MyStrings.state.tr,
              textInputType: TextInputType.phone,
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          spaceDown(Dimensions.space15.h),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              onChanged: () {},
              controller: controller.countryController,
              labelText: MyStrings.country.tr,
              textInputType: TextInputType.phone,
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          spaceDown(Dimensions.space15.h),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              onChanged: () {},
              controller: controller.zipController,
              labelText: MyStrings.zipCode.tr,
              textInputType: TextInputType.phone,
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          spaceDown(Dimensions.space15.h),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              onChanged: () {},
              controller: controller.postcodeController,
              labelText: MyStrings.postCode.tr,
              textInputType: TextInputType.phone,
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: Column(
              children: [
                spaceDown(Dimensions.space48.h),
                CustomElevatedBtn(
                  isLoading: controller.isSubmitting,
                  text: MyStrings.update.tr,
                  onTap: () {
                    controller.updateCoupon(
                        widget.couponDataList[widget.index].id.toString());
                  },
                  height: Dimensions.space56.h,
                  radius: Dimensions.largeRadius,
                ),
              ],
            ),
          ),
        ],
      );
    });
  }
}
