import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/advance_switch/custom_switch.dart';
import 'package:ovosale/app/components/alert-dialog/custom_alert_dialog.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/screens/supplier/widgets/supplier_update_pop.dart';
import 'package:ovosale/core/helper/date_converter.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/supplier/supplier_controller.dart';
import 'package:ovosale/data/model/supplier/supplier_response_model.dart';

import '../../../../core/app_permission/app_permission.dart';
import '../../../../data/controller/cart/global_controller.dart';

class SupplierListTile extends StatelessWidget {
  final List<SuppliersData> suppliersData;
  final int index;
  const SupplierListTile({
    super.key,
    required this.suppliersData,
    required this.index,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<SupplierController>(
      builder: (controller) => ListTile(
          contentPadding: EdgeInsetsDirectional.zero,
          title: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(
                suppliersData[index].name.toString(),
                style: theme.textTheme.headlineSmall
                    ?.copyWith(fontSize: Dimensions.space16.sp),
              ),
              suppliersData[index].companyName.toString() != "null"
                  ? Text(
                      "${MyStrings.companyName.tr} : ${suppliersData[index].companyName.toString()}  ",
                      style: theme.textTheme.bodySmall
                          ?.copyWith(fontWeight: FontWeight.w600),
                    )
                  : const SizedBox(),
              suppliersData[index].email.toString() != "null"
                  ? Text(
                      "${MyStrings.companyName.tr} : ${suppliersData[index].email.toString()}  ",
                      style: theme.textTheme.bodySmall
                          ?.copyWith(fontWeight: FontWeight.w600),
                    )
                  : const SizedBox(),
              Text(
                "${MyStrings.joinedAt.tr} : ${DateConverter.convertIsoToString(suppliersData[index].createdAt.toString())}  ",
                style: theme.textTheme.bodySmall
                    ?.copyWith(fontWeight: FontWeight.w600),
              ),
            ],
          ),
          trailing: Row(mainAxisSize: MainAxisSize.min, children: [
            CustomSwitch(
              isLoading: controller.taxUpdateLoadingIndex ==
                  controller.filteredSupplierData[index].id,
              value: controller.filteredSupplierData[index].status == "1"
                  ? true
                  : false,
              onChanged: (v) {
                controller.changeStatus(
                    controller.filteredSupplierData[index].id.toString(),
                    index,
                    v);
              },
            ),
            spaceSide(Dimensions.space12),
            CustomAppCard(
              onPressed: () {
                if (Get.find<GlobalController>().checkPermission(
                    featureName: AppPermissions.editSupplier)) {
                  controller.getSelectedItemValue(index);
                  controller.getData(index);
                  CustomAlertDialog(
                    child: UpdateSupplierPopup(
                      index: index,
                      couponDataList: suppliersData,
                    ),
                  ).customAlertDialog(context);
                }
              },
              showBorder: false,
              padding: EdgeInsetsDirectional.all(Dimensions.space8),
              radius: Dimensions.space8,
              height: Dimensions.space32.h,
              width: Dimensions.space32.w,
              backgroundColor:
                  MyColor.getInformationColor().withValues(alpha: .2),
              child: MyAssetImageWidget(
                assetPath: MyIcons.edit,
                isSvg: true,
                height: Dimensions.space10.h,
                width: Dimensions.space16.w,
              ),
            ),
          ])),
    );
  }
}
