import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/supplier/new_supplier_controller.dart';
import 'package:ovosale/data/repo/supplier/new_supplier_repo.dart';

class NewSupplierScreen extends StatefulWidget {
  const NewSupplierScreen({super.key});

  @override
  State<NewSupplierScreen> createState() => _NewSupplierScreenState();
}

class _NewSupplierScreenState extends State<NewSupplierScreen> {
  @override
  void initState() {
    Get.put(NewSupplierRepo());
    final controller =
        Get.put(NewSupplierController(newSupplierRepo: Get.find()));

    super.initState();
    controller.getData();
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<NewSupplierController>(
      builder: (controller) => MyCustomScaffold(
        padding: EdgeInsetsDirectional.zero,
        pageTitle: MyStrings.newSupplier.tr,
        body: SingleChildScrollView(
          child: CustomAppCard(
              radius: 0,
              margin: EdgeInsetsDirectional.symmetric(
                  vertical: Dimensions.space10.h),
              showBorder: false,
              child: Column(children: [
                LabelTextField(
                  isRequired: true,
                  onChanged: () {},
                  controller: controller.nameController,
                  labelText: MyStrings.name.tr,
                  textInputType: TextInputType.emailAddress,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space10),
                LabelTextField(
                  isRequired: true,
                  onChanged: () {},
                  controller: controller.companyNameController,
                  labelText: MyStrings.companyName.tr,
                  textInputType: TextInputType.emailAddress,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space10),
                LabelTextField(
                  onChanged: () {},
                  controller: controller.emailController,
                  labelText: MyStrings.email.tr,
                  textInputType: TextInputType.emailAddress,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space10),
                LabelTextField(
                  isRequired: true,
                  onChanged: () {},
                  controller: controller.mobileController,
                  labelText: MyStrings.phoneNumber.tr,
                  textInputType: TextInputType.phone,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space10),
                LabelTextField(
                  onChanged: () {},
                  controller: controller.addressController,
                  labelText: MyStrings.address.tr,
                  textInputType: TextInputType.text,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space15.h),
                LabelTextField(
                  onChanged: () {},
                  controller: controller.cityController,
                  labelText: MyStrings.city.tr,
                  textInputType: TextInputType.phone,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space15.h),
                LabelTextField(
                  onChanged: () {},
                  controller: controller.stateController,
                  labelText: MyStrings.state.tr,
                  textInputType: TextInputType.phone,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space15.h),
                LabelTextField(
                  onChanged: () {},
                  controller: controller.countryController,
                  labelText: MyStrings.country.tr,
                  textInputType: TextInputType.phone,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space15.h),
                LabelTextField(
                  onChanged: () {},
                  controller: controller.zipController,
                  labelText: MyStrings.zipCode.tr,
                  textInputType: TextInputType.phone,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space15.h),
                LabelTextField(
                  onChanged: () {},
                  controller: controller.postcodeController,
                  labelText: MyStrings.postCode.tr,
                  textInputType: TextInputType.phone,
                  textInputAction: TextInputAction.next,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
                spaceDown(Dimensions.space15.h),
                CustomElevatedBtn(
                  isLoading: controller.isSubmitting,
                  text: MyStrings.save.tr,
                  onTap: () {
                    if (controller.nameController.text != "") {
                      if (controller.companyNameController.text != "") {
                        controller.createSupplier();
                      } else {
                        CustomSnackBar.error(
                            errorList: [MyStrings.companyNameisRequired.tr]);
                      }
                    } else {
                      CustomSnackBar.error(
                          errorList: [MyStrings.nameisRequired.tr]);
                    }
                  },
                  height: Dimensions.space56.h,
                  radius: Dimensions.largeRadius,
                ),
              ])),
        ),
      ),
    );
  }
}
