import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/core/utils/my_color.dart';
import 'package:ovosale/core/utils/my_images.dart';
import 'package:ovosale/core/utils/util.dart';
import 'package:ovosale/data/controller/splash/splash_controller.dart';
import 'package:ovosale/data/repo/auth/general_setting_repo.dart';

class SplashScreen extends StatefulWidget {
  const SplashScreen({super.key});

  @override
  State<SplashScreen> createState() => _SplashScreenState();
}

class _SplashScreenState extends State<SplashScreen> {
  @override
  void initState() {
    MyUtils.splashScreen();

    Get.put(GeneralSettingRepo());
    final controller = Get.put(SplashController(repo: Get.find()));

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.gotoNextPage();
    });
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<SplashController>(
      builder: (controller) => Scaffold(
        backgroundColor: MyColor.getScaffoldBackgroundColor(),
        body: Stack(
          children: [
            Align(
              alignment: Alignment.center,
              child: MyAssetImageWidget(
                boxFit: BoxFit.contain,
                height: MediaQuery.of(context).size.height * 1.5,
                width: MediaQuery.of(context).size.width * .6,
                assetPath: MyImages.logo,
              ),
            ),
          ],
        ),
      ),
    );
  }
}
