import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/text-field/custom_text_field.dart';
import 'package:ovosale/core/app_permission/app_permission.dart';
import 'package:ovosale/core/utils/dimensions.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/controller/account/settings_controller.dart';
import 'package:ovosale/data/controller/cart/global_controller.dart';

import '../../../../core/utils/my_icons.dart';
import '../../../components/image/my_asset_widget.dart';

class EditSettingsForm extends StatefulWidget {
  const EditSettingsForm({super.key});

  @override
  State<EditSettingsForm> createState() => _EditSettingsFormState();
}

class _EditSettingsFormState extends State<EditSettingsForm> {
  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<SettingsController>(
      builder: (controller) => Container(
        width: MediaQuery.of(context).size.width,
        padding: const EdgeInsets.symmetric(
            vertical: Dimensions.space15, horizontal: Dimensions.space15),
        alignment: Alignment.center,
        decoration: BoxDecoration(
            color: Theme.of(context).cardColor,
            borderRadius: BorderRadius.circular(10)),
        child: Form(
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Text(
                    MyStrings.companySettings.tr,
                    style: theme.textTheme.titleSmall,
                  ),
                  Visibility(
                    visible: Get.find<GlobalController>().checkPermission(
                        featureName: AppPermissions.companySetting,
                        isShowSnackBar: false),
                    child: IconButton(
                        onPressed: () {
                          controller.onEditCompanySettings();
                        },
                        icon: MyAssetImageWidget(
                          assetPath: MyIcons.edit,
                          isSvg: true,
                          height: Dimensions.space17.h,
                          width: Dimensions.space17.w,
                        )),
                  )
                ],
              ),
              const SizedBox(height: Dimensions.space15),
              CustomTextField(
                  animatedLabel: true,
                  needOutlineBorder: true,
                  labelText: MyStrings.companyName.tr,
                  onChanged: (value) {},
                  focusNode: controller.companyNameFocusNode,
                  controller: controller.companyNameController,
                  readOnly: controller.isCompanySettingsEdit),
              const SizedBox(height: Dimensions.space15),
              CustomTextField(
                  animatedLabel: true,
                  needOutlineBorder: true,
                  labelText: MyStrings.email.tr,
                  onChanged: (value) {},
                  focusNode: controller.emailFocusNode,
                  controller: controller.emailController,
                  readOnly: controller.isCompanySettingsEdit),
              const SizedBox(height: Dimensions.space15),
              CustomTextField(
                  animatedLabel: true,
                  needOutlineBorder: true,
                  labelText: MyStrings.phone.tr,
                  onChanged: (value) {},
                  focusNode: controller.phoneFocusNode,
                  controller: controller.phoneController,
                  readOnly: controller.isCompanySettingsEdit),
              const SizedBox(height: Dimensions.space15),
              CustomTextField(
                  animatedLabel: true,
                  needOutlineBorder: true,
                  labelText: MyStrings.address.tr,
                  onChanged: (value) {},
                  focusNode: controller.addressFocusNode,
                  controller: controller.addressController,
                  readOnly: controller.isCompanySettingsEdit),
              const SizedBox(height: Dimensions.space15),
              controller.isCompanySettingsEdit == false
                  ? Align(
                      alignment: Alignment.centerRight,
                      child: CustomElevatedBtn(
                        width: 100,
                        height: 40,
                        isLoading: controller.isCompanyUpdateLoading,
                        radius: 10,
                        onTap: () {
                          controller.updateCompanySettings();
                        },
                        text: MyStrings.submit.tr,
                      ),
                    )
                  : SizedBox.shrink(),
              SizedBox(height: Dimensions.space10.h),
              Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Text(
                    MyStrings.prefixSettings.tr,
                    style: theme.textTheme.titleSmall,
                  ),
                  Visibility(
                    visible: Get.find<GlobalController>().checkPermission(
                        featureName: AppPermissions.prefixSetting,
                        isShowSnackBar: false),
                    child: IconButton(
                        onPressed: () {
                          controller.onEditPrefixSettings();
                        },
                        icon: MyAssetImageWidget(
                          assetPath: MyIcons.edit,
                          isSvg: true,
                          height: Dimensions.space17.h,
                          width: Dimensions.space17.w,
                        )),
                  )
                ],
              ),
              const SizedBox(height: Dimensions.space15),
              CustomTextField(
                  animatedLabel: true,
                  needOutlineBorder: true,
                  labelText: MyStrings.purchaseInvoicePrefix.tr,
                  onChanged: (value) {},
                  focusNode: controller.purchaseInvoiceFocusNode,
                  controller: controller.purchaseInvoiceController,
                  readOnly: controller.isPrefixSettingsEdit),
              const SizedBox(height: Dimensions.space15),
              CustomTextField(
                  animatedLabel: true,
                  needOutlineBorder: true,
                  labelText: MyStrings.saleInvoicePrefix.tr,
                  onChanged: (value) {},
                  focusNode: controller.saleInvoiceFocusNode,
                  controller: controller.saleInvoiceController,
                  readOnly: controller.isPrefixSettingsEdit),
              const SizedBox(height: Dimensions.space15),
              CustomTextField(
                  animatedLabel: true,
                  needOutlineBorder: true,
                  labelText: MyStrings.productCodePrefix.tr,
                  onChanged: (value) {},
                  focusNode: controller.productCodePrefixFocusNode,
                  controller: controller.productCodePrefixController,
                  readOnly: controller.isPrefixSettingsEdit),
              const SizedBox(height: Dimensions.space15),
              CustomTextField(
                  animatedLabel: true,
                  needOutlineBorder: true,
                  labelText: MyStrings.stockTransferInvoicePrefix.tr,
                  onChanged: (value) {},
                  focusNode: controller.stockTransferInvoicePrefixFocusNode,
                  controller: controller.stockTransferInvoicePrefixController,
                  readOnly: controller.isPrefixSettingsEdit),
              const SizedBox(height: Dimensions.space15),
              controller.isPrefixSettingsEdit == false
                  ? Align(
                      alignment: Alignment.centerRight,
                      child: CustomElevatedBtn(
                        width: 100,
                        height: 40,
                        isLoading: controller.isPrefixUpdateLoading,
                        radius: 10,
                        onTap: () {
                          controller.updatePrefixSettings();
                        },
                        text: MyStrings.submit.tr,
                      ),
                    )
                  : SizedBox.shrink(),
            ],
          ),
        ),
      ),
    );
  }
}
