import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/custom_loader/custom_loader.dart';
import 'package:ovosale/app/screens/settings/widget/edit_profile_form.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/controller/account/settings_controller.dart';
import 'package:ovosale/data/repo/account/settings_repo.dart';

class SettingsScreen extends StatefulWidget {
  const SettingsScreen({super.key});

  @override
  State<SettingsScreen> createState() => _SettingsScreenState();
}

class _SettingsScreenState extends State<SettingsScreen> {
  @override
  void initState() {
    Get.put(SettingsRepo());
    final controller = Get.put(SettingsController(settingsRepo: Get.find()));

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.loadData();
    });
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<SettingsController>(
      builder: (controller) => MyCustomScaffold(
        pageTitle: MyStrings.settings.tr,
        body: controller.isLoading
            ? const CustomLoader()
            : Stack(
                children: [
                  const Align(
                    alignment: Alignment.topCenter,
                    child: SingleChildScrollView(
                      child: Column(
                        children: [EditSettingsForm()],
                      ),
                    ),
                  )
                ],
              ),
      ),
    );
  }
}
