import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/core/utils/my_color.dart';
import 'package:ovosale/core/utils/my_strings.dart';

class SaleStatusWidget extends StatelessWidget {
  final String status;

  const SaleStatusWidget({super.key, required this.status});

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);

    return CustomAppCard(
        padding: EdgeInsets.symmetric(horizontal: 8, vertical: 2),
        radius: 4,
        backgroundColor: status == "1"
            ? MyColor.getSuccessColor().withValues(alpha: .1)
            : status == "2"
                ? MyColor.pendingColor.withValues(alpha: .1)
                : MyColor.transparent,
        child: Text(
            status == "1"
                ? MyStrings.final_.tr
                : status == "2"
                    ? MyStrings.quotation.tr
                    : "",
            style: theme.textTheme.titleSmall?.copyWith(
                fontSize: 12,
                color: status == "1"
                    ? MyColor.getSuccessColor()
                    : status == "2"
                        ? MyColor.pendingColor
                        : MyColor.black)));
  }
}
