import 'package:flutter/material.dart';
import 'package:get/get.dart';

class RightTopSaleSection extends StatelessWidget {
  final String title;
  final String? value1;
  final String? value2;
  final Widget? statusWidget;

  const RightTopSaleSection(
      {super.key,
      required this.title,
      this.value1,
      this.value2,
      this.statusWidget});

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);

    return Expanded(
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.end,
        children: [
          Text(
            title.tr,
            style:
                theme.textTheme.bodySmall?.copyWith(color: theme.primaryColor),
          ),
          SizedBox(
            height: 15,
          ),
          statusWidget!
        ],
      ),
    );
  }
}
