import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/role_and_permission/role_and_permission_controller.dart';
import 'package:ovosale/data/model/role_and_permission/role_and_permission_response_model.dart';

class RoleUpdatePopup extends StatefulWidget {
  final List<Role> roleData;
  final int index;
  const RoleUpdatePopup({
    super.key,
    required this.roleData,
    required this.index,
  });

  @override
  State<RoleUpdatePopup> createState() => _RoleUpdatePopupState();
}

class _RoleUpdatePopupState extends State<RoleUpdatePopup> {
  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<RoleAndPermissionController>(builder: (controller) {
      controller.methodNameController.text =
          widget.roleData[widget.index].name.toString();
      return Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: Row(
              children: [
                Expanded(
                    child: Text(MyStrings.updateRoleAndPermission.tr,
                        style: theme.textTheme.headlineSmall)),
                GestureDetector(
                  onTap: () {
                    Get.back();
                  },
                  child: MyAssetImageWidget(
                    assetPath: MyIcons.popUpCancel,
                    height: Dimensions.space45.h,
                    width: Dimensions.space45.w,
                    isSvg: true,
                  ),
                )
              ],
            ),
          ),
          CustomDivider(),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: LabelTextField(
              onChanged: () {},
              controller: controller.methodNameController,
              labelText: MyStrings.name.tr,
              textInputType: TextInputType.emailAddress,
              textInputAction: TextInputAction.next,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
          ),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
                horizontal: Dimensions.space16.w),
            child: Column(
              children: [
                spaceDown(Dimensions.space30.h),
                CustomElevatedBtn(
                  isLoading: controller.submitLoading,
                  text: MyStrings.update.tr,
                  onTap: () {
                    controller.updateMethod(
                      widget.roleData[widget.index].id.toString(),
                    );
                  },
                  height: Dimensions.space56.h,
                  radius: Dimensions.largeRadius,
                ),
              ],
            ),
          ),
        ],
      );
    });
  }
}
