import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/advance_switch/custom_switch.dart';
import 'package:ovosale/app/components/alert-dialog/custom_alert_dialog.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/screens/role_and_permission/role_and_permission/widgets/role_and_permission_update_pop_up.dart';
import 'package:ovosale/core/route/route.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/role_and_permission/role_and_permission_controller.dart';

class RoleandPermissionTile extends StatelessWidget {
  final int index;
  const RoleandPermissionTile({
    super.key,
    required this.index,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<RoleAndPermissionController>(
      builder: (controller) => ListTile(
        onTap: () {
          Get.toNamed(RouteHelper.newRoleandPermissionScreen,
              arguments: [controller.filteredRole[index]]);
        },
        contentPadding: EdgeInsetsDirectional.zero,
        title: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Text(
              controller.filteredRole[index].name ??
                  "${controller.filteredRole[index].id}",
              style: theme.textTheme.titleSmall,
            ),
          ],
        ),
        trailing: Row(
          mainAxisSize: MainAxisSize.min,
          children: [
            CustomSwitch(
              isLoading: controller.taxUpdateLoadingIndex ==
                  controller.filteredRole[index].id,
              value:
                  controller.filteredRole[index].status == "1" ? true : false,
              onChanged: (v) {
                controller.changeStatus(
                    controller.filteredRole[index].id.toString(), index, v);
              },
            ),
            spaceSide(Dimensions.space10),
            CustomAppCard(
                onPressed: () {
                  CustomAlertDialog(
                      child: RoleUpdatePopup(
                    index: index,
                    roleData: controller.filteredRole,
                  )).customAlertDialog(context);
                },
                showBorder: false,
                padding: EdgeInsetsDirectional.all(8),
                radius: Dimensions.space8,
                height: Dimensions.space32.h,
                width: Dimensions.space32.w,
                backgroundColor:
                    MyColor.getInformationColor().withValues(alpha: .2),
                child: MyAssetImageWidget(
                  assetPath: MyIcons.edit,
                  isSvg: true,
                  height: Dimensions.space10.h,
                  width: Dimensions.space16.w,
                )),
            SizedBox(
              width: 10.w,
            ),
            Icon(
              Icons.arrow_forward_ios_sharp,
              size: 18,
              color: theme.disabledColor,
            )
          ],
        ),
      ),
    );
  }
}
