import 'package:flutter/cupertino.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/app/components/no_data.dart';
import 'package:ovosale/app/components/shimmer/payment_method_shimmer.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/app/screens/role_and_permission/role_and_permission/widgets/role_and_permission_tile.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/role_and_permission/role_and_permission_controller.dart';
import 'package:ovosale/data/repo/role_and_permission/role_and_permission_repo.dart';

class RoleAndPermissionScreen extends StatefulWidget {
  const RoleAndPermissionScreen({super.key});

  @override
  State<RoleAndPermissionScreen> createState() =>
      _RoleAndPermissionScreenState();
}

class _RoleAndPermissionScreenState extends State<RoleAndPermissionScreen> {
  @override
  void initState() {
    Get.put(RoleandPermissionRepo());
    final controller =
        Get.put(RoleAndPermissionController(roleandPermissionRepo: Get.find()));
    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.getRoleandPermissionData();
    });
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<RoleAndPermissionController>(
      builder: (controller) => MyCustomScaffold(
        pageTitle: MyStrings.roleAndPermission.tr,
        padding: EdgeInsets.zero,
        body: Column(
          children: [
            Container(
              padding: EdgeInsetsDirectional.symmetric(
                  horizontal: Dimensions.space16.w,
                  vertical: Dimensions.space12.h),
              color: MyColor.white,
              child: LabelTextField(
                labelText: "",
                hideLabel: true,
                hintText: MyStrings.search.tr,
                hintTextColor: MyColor.getBodyTextColor(),
                onChanged: (value) {
                  controller.filterRoleAndPermission(value);
                },
                textInputType: TextInputType.text,
                textInputAction: TextInputAction.done,
                radius: Dimensions.largeRadius,
                validator: (value) {
                  if (value!.isEmpty) {
                    return MyStrings.fieldErrorMsg.tr;
                  } else {
                    return null;
                  }
                },
                prefixIcon: Icon(
                  CupertinoIcons.search,
                  size: Dimensions.textFieldIconSize,
                ),
              ),
            ),
            spaceDown(Dimensions.space10),
            controller.isLoading
                ? PaymentMethodShimmer()
                : controller.filteredRole.isEmpty
                    ? Center(
                        child: SizedBox(
                          height: MediaQuery.of(context).size.height * 0.5,
                          child: NoDataWidget(),
                        ),
                      )
                    : CustomAppCard(
                        radius: 0,
                        showBorder: false,
                        child: ListView.separated(
                          physics: const NeverScrollableScrollPhysics(),
                          separatorBuilder: (context, index) =>
                              CustomDivider(space: Dimensions.space16.h),
                          shrinkWrap: true,
                          itemCount: controller.filteredRole.length,
                          itemBuilder: (context, i) {
                            return RoleandPermissionTile(
                              index: i,
                            );
                          },
                        ),
                      ),
          ],
        ),
      ),
    );
  }
}
