import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/role_and_permission/new_role_and_permission_controller.dart';
import 'package:ovosale/data/model/role_and_permission/new_role_and_permission_model.dart';

class NewRoleandPermissionTile extends StatelessWidget {
  final Permission permission;

  const NewRoleandPermissionTile({
    super.key,
    required this.permission,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);

    return GetBuilder<NewRoleAndPermissionController>(
      builder: (controller) {
        bool isActive = controller.activePermissionIds.contains(permission.id);

        return ListTile(
          contentPadding: EdgeInsetsDirectional.zero,
          title: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(
                permission.name?.toTitleCase() ?? "",
                style: theme.textTheme.titleSmall,
                maxLines: 2,
                overflow: TextOverflow.ellipsis,
              ),
            ],
          ),
          trailing: Padding(
            padding: const EdgeInsetsDirectional.all(Dimensions.space10),
            child: Checkbox(
              value: isActive,
              onChanged: (v) {
                controller.addPermissionCheckbox(permission.id.toString());
              },
              activeColor: theme.primaryColor,
            ),
          ),
        );
      },
    );
  }
}
