import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/advance_switch/custom_switch.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/custom_loader/custom_loader.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/app/screens/role_and_permission/new_role_and_permission/widgets/new_role_and_permission_list_tile.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/role_and_permission/new_role_and_permission_controller.dart';
import 'package:ovosale/data/model/role_and_permission/new_role_and_permission_model.dart';
import 'package:ovosale/data/repo/role_and_permission/new_role_and_permission_repo.dart';

class NewRoleAndPermissionScreen extends StatefulWidget {
  const NewRoleAndPermissionScreen({super.key});

  @override
  State<NewRoleAndPermissionScreen> createState() =>
      _NewRoleAndPermissionScreenState();
}

class _NewRoleAndPermissionScreenState
    extends State<NewRoleAndPermissionScreen> {
  @override
  void initState() {
    Get.put(NewRoleandPermissionRepo());
    final controller = Get.put(
        NewRoleAndPermissionController(newRoleandPermissionRepo: Get.find()));
    super.initState();

    controller.roleId = Get.arguments[0];

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.getNewRoleandPermissionData();
    });
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<NewRoleAndPermissionController>(
      builder: (controller) => MyCustomScaffold(
        pageTitle: MyStrings.editPermission.tr,
        actionButton: [
          Visibility(
            visible: controller.isLoading == false,
            child: Padding(
              padding: EdgeInsets.only(right: 15.w),
              child: CustomSwitch(
                value: controller.selectAll,
                onChanged: (v) {
                  controller.selectAllItems();
                },
              ),
            ),
          ),
        ],
        body: controller.isLoading
            ? CustomLoader()
            : SingleChildScrollView(
                physics: const BouncingScrollPhysics(),
                child: Column(
                  children: [
                    spaceDown(Dimensions.space10),
                    ListView.builder(
                      physics: NeverScrollableScrollPhysics(),
                      shrinkWrap: true,
                      itemCount: controller.groupNames.length,
                      itemBuilder: (context, groupIndex) {
                        String groupName = controller.groupNames[groupIndex];
                        List<Permission> groupPermissions =
                            controller.groupedPermissions[groupName] ?? [];

                        return CustomAppCard(
                          onPressed: () {
                            controller.toggleGroup(groupIndex);
                          },
                          radius: Dimensions.space10,
                          margin: EdgeInsetsDirectional.symmetric(
                              vertical: Dimensions.space5),
                          padding: EdgeInsets.zero,
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Padding(
                                padding: const EdgeInsetsDirectional.symmetric(
                                    vertical: Dimensions.space12,
                                    horizontal: Dimensions.space12),
                                child: Row(
                                  mainAxisAlignment:
                                      MainAxisAlignment.spaceBetween,
                                  children: [
                                    Text(
                                      groupName.toTitleCase(),
                                      style: theme.textTheme.titleSmall,
                                    ),
                                    CustomSwitch(
                                      value: controller
                                          .isGroupSwitchOn(groupIndex),
                                      onChanged: (v) {
                                        controller
                                            .toggleGroupSwitch(groupIndex);
                                      },
                                    ),
                                  ],
                                ),
                              ),
                              controller.expandedGroupIndex == groupIndex
                                  ? CustomDivider(
                                      thickness: 1,
                                    )
                                  : SizedBox(),
                              controller.expandedGroupIndex == groupIndex
                                  ? CustomAppCard(
                                      padding: EdgeInsetsDirectional.symmetric(
                                          horizontal: Dimensions.space12),
                                      radius: 0,
                                      showBorder: false,
                                      child: Column(
                                        children: [
                                          GridView.builder(
                                            gridDelegate:
                                                SliverGridDelegateWithFixedCrossAxisCount(
                                                    crossAxisCount: 2,
                                                    childAspectRatio: 3.7),
                                            physics:
                                                const NeverScrollableScrollPhysics(),
                                            shrinkWrap: true,
                                            itemCount: groupPermissions.length,
                                            itemBuilder: (context, i) {
                                              return NewRoleandPermissionTile(
                                                permission: groupPermissions[i],
                                              );
                                            },
                                          ),
                                          spaceDown(Dimensions.space20)
                                        ],
                                      ),
                                    )
                                  : SizedBox(),
                            ],
                          ),
                        );
                      },
                    ),
                    spaceDown(Dimensions.space100),
                  ],
                ),
              ),
        floatingActionButtonCenter: true,
        floatingActionButton: Padding(
          padding:
              EdgeInsetsDirectional.symmetric(horizontal: Dimensions.space15.w),
          child: CustomElevatedBtn(
            isLoading: controller.submitLoading,
            text: MyStrings.update.tr,
            onTap: () {
              controller.updatePermission();
            },
            height: Dimensions.space56.h,
            radius: Dimensions.largeRadius,
          ),
        ),
      ),
    );
  }
}
