import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/no_data.dart';
import 'package:ovosale/app/components/shimmer/purchase_report_shimmer.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/dimensions.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';

import '../../../../data/controller/report/report_controller.dart';
import '../../../../data/repo/report_repo/report_repo.dart';
import '../../../components/card/custom_app_card.dart';
import '../../../components/custom_loader/custom_loader.dart';
import 'card_elements.dart';

class SalesReportWidget extends StatefulWidget {
  const SalesReportWidget({
    super.key,
  });

  @override
  State<SalesReportWidget> createState() => _SalesReportWidgetState();
}

class _SalesReportWidgetState extends State<SalesReportWidget> {
  final ScrollController scrollController = ScrollController();
  void scrollListener() {
    if (scrollController.position.pixels ==
        scrollController.position.maxScrollExtent) {
      if (Get.find<ReportController>().hasNext()) {
        Get.find<ReportController>().getSalesReportData(isPagination: true);
      }
    }
  }

  @override
  void initState() {
    Get.put(ReportRepo());
    final controller = Get.put(ReportController(reportRepo: Get.find()));

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.getSalesReportData();
      scrollController.addListener(scrollListener);
    });
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<ReportController>(
      builder: (controller) => controller.isLoading
          ? ReportShimmer()
          : controller.salesReportList.isEmpty
              ? NoDataWidget()
              : ListView.builder(
                  padding: EdgeInsets.only(bottom: Dimensions.space100.h),
                  controller: scrollController,
                  itemCount: controller.salesReportList.length + 1,
                  itemBuilder: (context, index) {
                    if (controller.salesReportList.length == index) {
                      return controller.hasNext()
                          ? const CustomLoader(isPagination: true)
                          : const SizedBox();
                    }

                    var report = controller.salesReportList[index];

                    return CustomAppCard(
                        padding: EdgeInsets.symmetric(
                            horizontal: 10.h, vertical: 8.h),
                        margin: EdgeInsets.symmetric(
                            horizontal: 10.h, vertical: 5.h),
                        radius: 8,
                        child: Column(
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                LeftTopSection(
                                  title:
                                      "${MyStrings.invoice.tr}/${MyStrings.totalItem.tr}",
                                  value1: report.invoiceNumber,
                                  value2:
                                      "${report.saleDetailsCount} ${MyStrings.items.tr}",
                                ),
                                CenterSection(
                                  title:
                                      "${MyStrings.amount.tr} | ${MyStrings.purchase.tr}",
                                  value1:
                                      "${SharedPreferenceService.getCurrencySymbol()}${AppConverter.formatNumber(report.total.toString())}",
                                  value2:
                                      "${SharedPreferenceService.getCurrencySymbol()}${AppConverter.formatNumber(report.totalPurchaseValue.toString())}",
                                ),
                                RightTopSection(
                                  title:
                                      "${MyStrings.profit.tr}/${MyStrings.loss.tr}",
                                  value1:
                                      "${SharedPreferenceService.getCurrencySymbol()}${controller.calculateProfitOrLoss(amount: report.total ?? "0.00", purchaseValue: report.totalPurchaseValue)}",
                                )
                              ],
                            ),
                            SizedBox(height: 12),
                            Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                BottomLeftSection(
                                  title: MyStrings.customer.tr,
                                  value1: report.customer?.name ?? "",
                                ),
                                BottomRightSection(
                                  title: MyStrings.saleDate.tr,
                                  value1: report.saleDate ?? "",
                                ),
                              ],
                            )
                          ],
                        ));
                  },
                ),
    );
  }
}
