import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/shimmer/purchase_report_shimmer.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/dimensions.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';

import '../../../../data/controller/report/report_controller.dart';
import '../../../../data/repo/report_repo/report_repo.dart';
import '../../../components/card/custom_app_card.dart';
import '../../../components/custom_loader/custom_loader.dart';
import '../../../components/no_data.dart';
import 'card_elements.dart';
import 'custom_status_widget.dart';

class PurchaseReportWidget extends StatefulWidget {
  const PurchaseReportWidget({
    super.key,
  });

  @override
  State<PurchaseReportWidget> createState() => _PurchaseReportWidgetState();
}

class _PurchaseReportWidgetState extends State<PurchaseReportWidget> {
  final ScrollController scrollController = ScrollController();
  void scrollListener() {
    if (scrollController.position.pixels ==
        scrollController.position.maxScrollExtent) {
      if (Get.find<ReportController>().hasNext()) {
        Get.find<ReportController>().getPurchaseReportData(isPagination: true);
      }
    }
  }

  @override
  void initState() {
    Get.put(ReportRepo());
    final controller = Get.put(ReportController(reportRepo: Get.find()));

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.getPurchaseReportData();
      scrollController.addListener(scrollListener);
    });
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<ReportController>(
      builder: (controller) => controller.isLoading
          ? ReportShimmer()
          : controller.purchaseReportList.isEmpty
              ? NoDataWidget()
              : ListView.builder(
                  padding: EdgeInsets.only(bottom: Dimensions.space100.h),
                  controller: scrollController,
                  itemCount: controller.purchaseReportList.length + 1,
                  itemBuilder: (context, index) {
                    if (controller.purchaseReportList.length == index) {
                      return controller.hasNext()
                          ? const CustomLoader(isPagination: true)
                          : const SizedBox();
                    }

                    var purchase = controller.purchaseReportList[index];

                    return CustomAppCard(
                        padding: EdgeInsets.symmetric(
                            horizontal: 10.h, vertical: 8.h),
                        margin: EdgeInsets.symmetric(
                            horizontal: 10.h, vertical: 5.h),
                        radius: 8,
                        child: Column(
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                LeftTopSection(
                                  title:
                                      "${MyStrings.invoice.tr} | ${MyStrings.reference.tr}",
                                  value1: purchase.invoiceNumber,
                                  value2: purchase.referenceNumber,
                                ),
                                CenterSection(
                                    title:
                                        "${MyStrings.total.tr} | ${MyStrings.paid.tr}",
                                    value1:
                                        "${SharedPreferenceService.getCurrencySymbol()}${AppConverter.formatNumber(purchase.total ?? "0.00")}",
                                    value2:
                                        "${SharedPreferenceService.getCurrencySymbol()}${AppConverter.formatNumber(purchase.supplierPaymentsSumAmount ?? "0.00")}"),
                                RightTopSection(
                                  title: MyStrings.status.tr,
                                  statusWidget: CustomStatusWidget(
                                      status: purchase.status ?? "-1"),
                                )
                              ],
                            ),
                            SizedBox(height: 12),
                            Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                BottomLeftSection(
                                  title: MyStrings.supplier.tr,
                                  value1: purchase.supplier?.name ?? "",
                                ),
                                BottomRightSection(
                                  title: MyStrings.purchaseDate.tr,
                                  value1: purchase.purchaseDate,
                                ),
                              ],
                            )
                          ],
                        ));
                  },
                ),
    );
  }
}
