import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/shimmer/purchase_report_shimmer.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/dimensions.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';
import '../../../../data/controller/report/report_controller.dart';
import '../../../../data/repo/report_repo/report_repo.dart';
import '../../../components/card/custom_app_card.dart';
import '../../../components/custom_loader/custom_loader.dart';
import '../../../components/no_data.dart';
import 'card_elements.dart';

class ProfitLossReport extends StatefulWidget {
  final double space;

  const ProfitLossReport({super.key, this.space = 12});

  @override
  State<ProfitLossReport> createState() => _ProfitLossReportState();
}

class _ProfitLossReportState extends State<ProfitLossReport> {
  final ScrollController scrollController = ScrollController();
  void scrollListener() {
    if (scrollController.position.pixels ==
        scrollController.position.maxScrollExtent) {
      if (Get.find<ReportController>().hasNext()) {
        Get.find<ReportController>()
            .getLossProfitReportData(isPagination: true);
      }
    }
  }

  @override
  void initState() {
    Get.put(ReportRepo());
    final controller = Get.put(ReportController(reportRepo: Get.find()));

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.getLossProfitReportData();
      scrollController.addListener(scrollListener);
    });
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<ReportController>(
      builder: (controller) => controller.isLoading
          ? ReportShimmer()
          : controller.profitLossReportList.isEmpty
              ? NoDataWidget()
              : ListView.builder(
                  padding: EdgeInsets.only(bottom: Dimensions.space100.h),
                  controller: scrollController,
                  itemCount: controller.profitLossReportList.length + 1,
                  itemBuilder: (context, index) {
                    if (controller.profitLossReportList.length == index) {
                      return controller.hasNext()
                          ? const CustomLoader(isPagination: true)
                          : const SizedBox();
                    }
                    var profitLoss = controller.profitLossReportList[index];
                    return CustomAppCard(
                        padding: EdgeInsets.symmetric(
                            horizontal: 10.h, vertical: 8.h),
                        margin: EdgeInsets.symmetric(
                            horizontal: 10.h, vertical: 5.h),
                        radius: 8,
                        child: Column(
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                LeftTopSection(
                                  title:
                                      "${MyStrings.invoice.tr} | ${MyStrings.sale.tr}",
                                  value1: profitLoss.invoiceNumber,
                                  value2: profitLoss.saleDate,
                                ),
                                CenterSection(
                                  title: MyStrings.purchasePrice.tr,
                                  value1:
                                      "${SharedPreferenceService.getCurrencySymbol()}${AppConverter.formatNumber(profitLoss.totalPurchasePrice ?? "0.00")}",
                                ),
                                RightTopSection(
                                  title: MyStrings.grossProfit.tr,
                                  value1:
                                      "${SharedPreferenceService.getCurrencySymbol()}${AppConverter.formatNumber(profitLoss.grossProfit ?? "")}",
                                )
                              ],
                            ),
                            SizedBox(height: widget.space),
                            Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                BottomLeftSection(
                                  title: MyStrings.salesPrice.tr,
                                  value1:
                                      "${SharedPreferenceService.getCurrencySymbol()}${AppConverter.formatNumber(profitLoss.totalSalesPrice ?? "")}",
                                ),
                                BottomRightSection(
                                  title: MyStrings.customer.tr,
                                  value1: profitLoss.customer?.name,
                                ),
                              ],
                            )
                          ],
                        ));
                  },
                ),
    );
  }
}
