import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/shimmer/purchase_report_shimmer.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/dimensions.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';

import '../../../../data/controller/report/report_controller.dart';
import '../../../../data/repo/report_repo/report_repo.dart';
import '../../../components/card/custom_app_card.dart';
import '../../../components/custom_loader/custom_loader.dart';
import '../../../components/no_data.dart';
import 'card_elements.dart';

class ExpenseReportWidget extends StatefulWidget {
  final double space;

  const ExpenseReportWidget({super.key, this.space = 12});

  @override
  State<ExpenseReportWidget> createState() => _ExpenseReportWidgetState();
}

class _ExpenseReportWidgetState extends State<ExpenseReportWidget> {
  final ScrollController scrollController = ScrollController();
  void scrollListener() {
    if (scrollController.position.pixels ==
        scrollController.position.maxScrollExtent) {
      if (Get.find<ReportController>().hasNext()) {
        Get.find<ReportController>().getExpenseReportData(isPagination: true);
      }
    }
  }

  @override
  void initState() {
    Get.put(ReportRepo());
    final controller = Get.put(ReportController(reportRepo: Get.find()));

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.getExpenseReportData();
      scrollController.addListener(scrollListener);
    });
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<ReportController>(
      builder: (controller) => controller.isLoading
          ? ReportShimmer()
          : controller.expenseReportList.isEmpty
              ? NoDataWidget()
              : ListView.builder(
                  padding: EdgeInsets.only(bottom: Dimensions.space100.h),
                  controller: scrollController,
                  itemCount: controller.expenseReportList.length + 1,
                  itemBuilder: (context, index) {
                    if (controller.expenseReportList.length == index) {
                      return controller.hasNext()
                          ? const CustomLoader(isPagination: true)
                          : const SizedBox();
                    }

                    var expense = controller.expenseReportList[index];

                    return CustomAppCard(
                        padding: EdgeInsets.symmetric(
                            horizontal: 10.h, vertical: 8.h),
                        margin: EdgeInsets.symmetric(
                            horizontal: 10.h, vertical: 5.h),
                        radius: 8,
                        child: Column(
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                LeftTopSection(
                                  title: MyStrings.date.tr,
                                  value1: expense.expenseDate,
                                ),
                                CenterSection(
                                  title: MyStrings.purpose.tr,
                                  value1: expense.category?.name,
                                ),
                                RightTopSection(
                                  title: MyStrings.amount.tr,
                                  value1:
                                      "${SharedPreferenceService.getCurrencySymbol()}${AppConverter.formatNumber(expense.amount ?? "")}",
                                )
                              ],
                            ),
                            SizedBox(height: widget.space),
                            Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                BottomLeftSection(
                                  title: MyStrings.referenceNo.tr,
                                  value1: expense.referenceNo,
                                ),
                                BottomRightSection(
                                  title: MyStrings.addedBy.tr,
                                  value1: expense.admin?.name ?? "",
                                ),
                              ],
                            )
                          ],
                        ));
                  },
                ),
    );
  }
}
