import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../../../../core/utils/my_color.dart';

class BottomRightSection extends StatelessWidget {
  final String title;
  final String? value1;
  final String? value2;
  final Widget? statusWidget;

  const BottomRightSection({
    super.key,
    required this.title,
    this.value1,
    this.value2,
    this.statusWidget,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return Expanded(
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.end,
        children: [
          Text(
            title.tr,
            style: theme.textTheme.bodySmall,
          ),
          Text(
            value1 ?? "",
            style: theme.textTheme.bodySmall,
          ),
          statusWidget != null
              ? statusWidget!
              : Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    if (value1 != null && value1!.contains("-1")) ...[
                      Text(
                        value1 ?? "",
                        style: theme.textTheme.bodySmall
                            ?.copyWith(color: MyColor.getErrorColor()),
                      ),
                    ] else ...[
                      Text(
                        value1 ?? "",
                        style: theme.textTheme.bodySmall
                            ?.copyWith(color: MyColor.getSuccessColor()),
                      ),
                    ],
                    Text(
                      value2 ?? "",
                      style: theme.textTheme.bodyMedium
                          ?.copyWith(color: MyColor.getSuccessColor()),
                    ),
                  ],
                )
        ],
      ),
    );
  }
}

class BottomCenterSection extends StatelessWidget {
  final String title;
  final String? value1;

  const BottomCenterSection({
    super.key,
    required this.title,
    this.value1,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return Expanded(
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          Text(
            title.tr,
            style: theme.textTheme.bodySmall,
          ),
          Text(
            value1 ?? "",
            style: theme.textTheme.bodySmall,
          ),
        ],
      ),
    );
  }
}

class BottomLeftSection extends StatelessWidget {
  final String title;
  final String? value1;
  const BottomLeftSection({
    super.key,
    required this.title,
    this.value1,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return Expanded(
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(
            title.tr,
            style: theme.textTheme.bodySmall,
          ),
          SizedBox(
            height: 2,
          ),
          Text(
            value1 ?? "",
            style: theme.textTheme.bodySmall,
          ),
        ],
      ),
    );
  }
}

class RightTopSection extends StatelessWidget {
  final String title;
  final String? value1;
  final String? value2;
  final Widget? statusWidget;

  const RightTopSection(
      {super.key,
      required this.title,
      this.value1,
      this.value2,
      this.statusWidget});

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);

    return Expanded(
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.end,
        children: [
          Text(
            title.tr,
            style:
                theme.textTheme.bodySmall?.copyWith(color: theme.primaryColor),
          ),
          SizedBox(
            height: 8,
          ),
          statusWidget != null
              ? statusWidget!
              : Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    if (value1 != null && value1!.contains("-1")) ...[
                      Text(
                        value1 ?? "",
                        style: theme.textTheme.bodySmall
                            ?.copyWith(color: MyColor.getErrorColor()),
                      ),
                    ] else ...[
                      Text(
                        value1 ?? "",
                        style: theme.textTheme.bodySmall
                            ?.copyWith(color: MyColor.getSuccessColor()),
                      ),
                    ],
                    Text(
                      value2 ?? "",
                      style: theme.textTheme.bodyMedium
                          ?.copyWith(color: MyColor.getSuccessColor()),
                    ),
                  ],
                )
        ],
      ),
    );
  }
}

class CenterSection extends StatelessWidget {
  final String title;
  final String? value1;
  final String? value2;

  const CenterSection({
    super.key,
    required this.title,
    this.value1,
    this.value2,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return Expanded(
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          Text(
            title.tr,
            style:
                theme.textTheme.bodySmall?.copyWith(color: theme.primaryColor),
          ),
          SizedBox(height: 8),
          Text(
            value1 ?? "",
            style: theme.textTheme.bodySmall,
          ),
          SizedBox(height: 2),
          Text(
            value2 ?? "",
            style: theme.textTheme.bodySmall,
          ),
        ],
      ),
    );
  }
}

class LeftTopSection extends StatelessWidget {
  final String title;
  final String? value1;
  final String? value2;

  const LeftTopSection({
    super.key,
    required this.title,
    this.value1,
    this.value2,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return Expanded(
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(title.tr,
              style: theme.textTheme.bodySmall?.copyWith(
                  color: theme.primaryColor, fontWeight: FontWeight.w600)),
          SizedBox(height: 8),
          Text(
            value1 ?? "",
            style: theme.textTheme.bodySmall
                ?.copyWith(fontWeight: FontWeight.w600),
          ),
          Text(
            value2 ?? "",
            style: theme.textTheme.bodySmall
                ?.copyWith(fontWeight: FontWeight.w600),
          ),
        ],
      ),
    );
  }
}
