import 'package:flutter/material.dart';
import 'package:get/get.dart';

class TextColumn extends StatelessWidget {
  final String title;
  final String subtitle;
  final String? secondSubtitle;
  final bool fromStart;
  const TextColumn(
      {super.key,
      required this.title,
      required this.subtitle,
      this.secondSubtitle,
      this.fromStart = true});

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return Column(
      crossAxisAlignment:
          fromStart ? CrossAxisAlignment.start : CrossAxisAlignment.end,
      children: [
        Text(
          title.tr,
          style:
              theme.textTheme.bodyMedium?.copyWith(fontWeight: FontWeight.w600),
        ),
        Text(
          subtitle,
          style: theme.textTheme.bodyMedium,
        ),
        secondSubtitle != ""
            ? Text(
                secondSubtitle ?? "",
                style: theme.textTheme.bodyMedium,
              )
            : SizedBox(),
      ],
    );
  }
}
