import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/app/components/row_widget/bottom_sheet_top_row.dart';
import 'package:ovosale/app/screens/purchase/widgets/text_column.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/model/purchase/purchase_data_response_model.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';

showPurchaseDetailsBottomSheet(List<PurchaseData>? purchaseData, int index,
    {required BuildContext context}) {
  if (purchaseData != null && purchaseData.isNotEmpty) {
    ThemeData theme = Theme.of(context);
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        BottomSheetTopRow(
          header: MyStrings.purchaseDetails.tr,
          bgColor: MyColor.white,
        ),
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Expanded(
              child: TextColumn(
                title: MyStrings.warehouse.tr,
                subtitle: "${purchaseData[index].warehouse?.name}",
              ),
            ),
            Container(
                height: Dimensions.space30.h,
                width: 1.w,
                color: theme.dividerColor),
            Expanded(
              child: TextColumn(
                fromStart: false,
                title: MyStrings.supplier.tr,
                subtitle: "${purchaseData[index].supplier?.name.toString()}",
              ),
            ),
          ],
        ),
        CustomDivider(),
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Expanded(
              child: TextColumn(
                title: MyStrings.totalAmount.tr,
                subtitle:
                    "${AppConverter.formatNumber(purchaseData[index].subtotal.toString())} ${SharedPreferenceService.getCurrencySymbol(isFullText: true)}",
              ),
            ),
            Container(
                height: Dimensions.space30.h,
                width: 1.w,
                color: theme.dividerColor),
            Expanded(
              child: TextColumn(
                fromStart: false,
                title: MyStrings.paidAmount.tr,
                subtitle:
                    "${AppConverter.formatNumber(purchaseData[index].supplierPaymentsSumAmount ?? "00")} ${SharedPreferenceService.getCurrencySymbol(isFullText: true)}",
              ),
            ),
          ],
        ),
      ],
    );
  }
}
