import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/bottom-sheet/custom_bottom_sheet.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/custom_loader/custom_loader.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/screens/purchase/widgets/purchase_tile_bottom_sheet.dart';
import 'package:ovosale/core/app_permission/app_permission.dart';
import 'package:ovosale/core/route/route.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/cart/global_controller.dart';
import 'package:ovosale/data/controller/purchase/purchase_controller.dart';
import 'package:ovosale/data/model/purchase/purchase_data_response_model.dart'
    as prefix;

class PurchaseScreenListTile extends StatelessWidget {
  final List<prefix.PurchaseData>? purchaseData;
  final int index;
  const PurchaseScreenListTile({
    super.key,
    required this.purchaseData,
    required this.index,
  });

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<PurchaseController>(
      builder: (controller) => InkWell(
        onTap: () {
          CustomBottomSheet(
                  child: showPurchaseDetailsBottomSheet(
                      context: context, purchaseData, index))
              .customBottomSheet(context);
        },
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Expanded(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Row(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(
                        "${MyStrings.invoice.tr} :",
                        style: theme.textTheme.bodyLarge?.copyWith(
                            fontSize: Dimensions.space16.sp,
                            fontWeight: FontWeight.w600),
                      ),
                      Expanded(
                        child: Text(
                          "${purchaseData?[index].invoiceNumber}",
                          style: theme.textTheme.bodyLarge
                              ?.copyWith(fontWeight: FontWeight.w400),
                        ),
                      ),
                    ],
                  ),
                  Row(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(
                        "${MyStrings.warehouse.tr}:",
                        style: theme.textTheme.bodyLarge?.copyWith(
                            fontSize: Dimensions.space16.sp,
                            fontWeight: FontWeight.w600),
                      ),
                      Expanded(
                        child: Text(
                          "${purchaseData?[index].warehouse?.name}",
                          style: theme.textTheme.bodyLarge
                              ?.copyWith(fontWeight: FontWeight.w400),
                        ),
                      ),
                    ],
                  ),
                  Row(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(
                        "${MyStrings.supplier.tr}:",
                        style: theme.textTheme.bodyLarge?.copyWith(
                            fontSize: Dimensions.space16.sp,
                            fontWeight: FontWeight.w600),
                      ),
                      Expanded(
                        child: Text(
                          "${purchaseData?[index].supplier?.name}",
                          style: theme.textTheme.bodyLarge
                              ?.copyWith(fontWeight: FontWeight.w400),
                        ),
                      ),
                    ],
                  ),
                  Row(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(
                        MyStrings.date.tr,
                        style: theme.textTheme.bodyLarge?.copyWith(
                            fontSize: Dimensions.space16.sp,
                            fontWeight: FontWeight.w600),
                      ),
                      Expanded(
                        child: Text(
                          ":${purchaseData?[index].purchaseDate}",
                          style: theme.textTheme.bodyLarge
                              ?.copyWith(fontWeight: FontWeight.w400),
                        ),
                      ),
                    ],
                  ),
                  spaceDown(Dimensions.space5),
                  CustomAppCard(
                      showBorder: false,
                      padding: EdgeInsetsDirectional.all(5),
                      radius: Dimensions.space8,
                      backgroundColor: purchaseData?[index].status.toString() ==
                              "1"
                          ? MyColor.getSuccessColor().withValues(alpha: .1)
                          : purchaseData?[index].status.toString() == "2"
                              ? MyColor.getWarningColor().withValues(alpha: .1)
                              : MyColor.getInformationColor()
                                  .withValues(alpha: .1),
                      child: Text(
                        purchaseData?[index].status.toString() == "1"
                            ? MyStrings.received.tr
                            : purchaseData?[index].status.toString() == "2"
                                ? MyStrings.pending.tr
                                : purchaseData?[index].status.toString() == "3"
                                    ? MyStrings.ordered.tr
                                    : "",
                        style: theme.textTheme.bodySmall?.copyWith(
                          fontWeight: FontWeight.bold,
                          color: purchaseData?[index].status.toString() == "1"
                              ? MyColor.getSuccessColor()
                              : purchaseData?[index].status.toString() == "2"
                                  ? MyColor.getWarningColor()
                                  : MyColor.getInformationColor(),
                        ),
                      )),
                ],
              ),
            ),
            Column(
              mainAxisSize: MainAxisSize.min,
              children: [
                CustomAppCard(
                    onPressed: () {
                      controller.pdfDownload(
                          purchaseData?[index].id.toString() ?? "0");
                    },
                    showBorder: false,
                    padding: EdgeInsetsDirectional.all(8),
                    radius: Dimensions.space8,
                    backgroundColor: MyColor.lightBorder,
                    child: controller.pdfLoadingIndex ==
                            purchaseData?[index].id.toString()
                        ? SizedBox(
                            height: Dimensions.space20,
                            width: Dimensions.space20,
                            child: FittedBox(
                              fit: BoxFit.contain,
                              child: CustomLoader(
                                isPagination: true,
                              ),
                            ),
                          )
                        : MyAssetImageWidget(
                            assetPath: MyIcons.pdfFile,
                            isSvg: true,
                            height: Dimensions.space16.h,
                            width: Dimensions.space16.w,
                          )),
                spaceDown(Dimensions.space5),
                CustomAppCard(
                    onPressed: () {
                      controller.getPurchaseAttachmentData(
                        purchaseData?[index].id.toString() ?? "",
                      );
                    },
                    showBorder: false,
                    padding: EdgeInsetsDirectional.all(4),
                    radius: Dimensions.space8,
                    backgroundColor: MyColor.getPrimaryColor(),
                    child: controller.fileDownloadLoadingIndex ==
                            purchaseData?[index].id.toString()
                        ? SizedBox(
                            height: Dimensions.space25,
                            width: Dimensions.space25,
                            child: FittedBox(
                              fit: BoxFit.contain,
                              child: CustomLoader(
                                isPagination: true,
                              ),
                            ),
                          )
                        : Icon(
                            Icons.downloading_outlined,
                            color: theme.cardColor,
                          )),
                spaceDown(Dimensions.space5),
                CustomAppCard(
                    onPressed: () {
                      if (Get.find<GlobalController>().checkPermission(
                          featureName: AppPermissions.editPurchase)) {
                        Get.toNamed(RouteHelper.editPurchaseScreen,
                                arguments: [purchaseData?[index].id.toString()])
                            ?.then((v) {
                          controller.getPurchaseData();
                        });
                      }
                    },
                    showBorder: false,
                    padding: EdgeInsetsDirectional.all(Dimensions.space8),
                    radius: Dimensions.space8,
                    backgroundColor:
                        MyColor.getInformationColor().withValues(alpha: .2),
                    child: MyAssetImageWidget(
                      assetPath: MyIcons.edit,
                      isSvg: true,
                      height: Dimensions.space15.h,
                      width: Dimensions.space16.w,
                    )),
              ],
            ),
          ],
        ),
      ),
    );
  }
}
