import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/text-field/custom_drop_down_text_field.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/app/components/text/header_text.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/purchase/new_purchase_controller.dart';

class NewPurchaseThirdStep extends StatefulWidget {
  const NewPurchaseThirdStep({
    super.key,
  });

  @override
  State<NewPurchaseThirdStep> createState() => _NewPurchaseThirdStepState();
}

class _NewPurchaseThirdStepState extends State<NewPurchaseThirdStep> {
  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<NewPurchaseController>(builder: (controller) {
      return Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          CustomAppCard(
              radius: Dimensions.space8,
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  HeaderText(text: MyStrings.purchaseSummery.tr),
                  CustomDivider(space: Dimensions.space10),
                  Row(
                    children: [
                      Flexible(
                        flex: 1,
                        child: CustomDropDownTextField(
                          selectedValue: controller.selectedPurchaseDiscountType,
                          onChanged: (value) {
                            controller.selectedPurchaseDiscountType = value;
                            controller.calculateTotal();
                          },
                          labelText: MyStrings.purchaseDiscount.tr,
                          items: controller.discountTypeData.map((item) {
                            return DropdownMenuItem(
                              value: item["name"],
                              child: Text(
                                item["name"] ?? "",
                                style: theme.textTheme.bodySmall,
                              ),
                            );
                          }).toList(),
                        ),
                      ),
                      spaceSide(Dimensions.space10),
                      Flexible(
                        flex: 1,
                        child: LabelTextField(
                          labelText: MyStrings.amount.tr,
                          controller: controller.purchaseDiscountController,
                          onChanged: (value) {
                            controller.calculateTotal();
                          },
                          contentPadding: EdgeInsetsDirectional.symmetric(vertical: Dimensions.space17.h, horizontal: Dimensions.space16.w),
                          textInputType: TextInputType.number,
                          textInputAction: TextInputAction.done,
                          radius: Dimensions.largeRadius,
                          validator: (value) {
                            if (value!.isEmpty) {
                              return MyStrings.fieldErrorMsg.tr;
                            } else {
                              return null;
                            }
                          },
                        ),
                      ),
                    ],
                  ),
                  spaceDown(Dimensions.space16.h),
                  LabelTextField(
                    labelText: MyStrings.shippingAmount.tr,
                    controller: controller.shippingAmountController,
                    onChanged: (value) {
                      controller.calculateTotal();
                    },
                    contentPadding: EdgeInsetsDirectional.symmetric(vertical: Dimensions.space17.h, horizontal: Dimensions.space16.w),
                    textInputType: TextInputType.number,
                    textInputAction: TextInputAction.done,
                    radius: Dimensions.largeRadius,
                    validator: (value) {
                      if (value!.isEmpty) {
                        return MyStrings.fieldErrorMsg.tr;
                      } else {
                        return null;
                      }
                    },
                  ),
                  spaceDown(Dimensions.space15),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Expanded(
                        child: Text(
                          MyStrings.subTotal.tr,
                          style: theme.textTheme.bodyLarge,
                        ),
                      ),
                      Flexible(
                        child: FittedBox(
                          fit: BoxFit.scaleDown,
                          child: Text(
                            "${controller.totalSubTotal.toString()}${controller.defaultCurrency}",
                            style: theme.textTheme.bodyLarge?.copyWith(color: MyColor.getAccent1Color()),
                          ),
                        ),
                      ),
                    ],
                  ),
                  CustomDivider(
                    space: Dimensions.space5.h,
                  ),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Expanded(
                        child: Text(
                          MyStrings.discountAmount.tr,
                          style: theme.textTheme.bodyLarge,
                        ),
                      ),
                      Flexible(
                        child: FittedBox(
                          fit: BoxFit.scaleDown,
                          child: Text(
                            controller.selectedPurchaseDiscountType == "Percent" ? "${AppConverter.formatNumber(controller.discountAmount.toString())}${controller.defaultCurrency} (${controller.purchaseDiscountController.text}%)" : "${controller.purchaseDiscountController.text} ${controller.defaultCurrency}",
                            style: theme.textTheme.bodyLarge?.copyWith(color: MyColor.getSuccessColor()),
                          ),
                        ),
                      ),
                    ],
                  ),
                  CustomDivider(
                    space: Dimensions.space5.h,
                  ),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Expanded(
                        child: Text(
                          MyStrings.shippingAmount.tr,
                          style: theme.textTheme.bodyLarge,
                        ),
                      ),
                      Flexible(
                        child: FittedBox(
                          fit: BoxFit.scaleDown,
                          child: Text(
                            "${controller.shippingAmountController.text.toString()}${controller.defaultCurrency}",
                            style: theme.textTheme.bodyLarge?.copyWith(color: MyColor.getSuccessColor()),
                          ),
                        ),
                      ),
                    ],
                  ),
                  CustomDivider(
                    space: Dimensions.space5.h,
                  ),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Expanded(
                        child: Text(
                          MyStrings.total.tr,
                          style: theme.textTheme.bodyLarge,
                        ),
                      ),
                      Flexible(
                        child: FittedBox(
                          fit: BoxFit.scaleDown,
                          child: Text(
                            "${AppConverter.formatNumber(controller.total.toString())}${controller.defaultCurrency}",
                            style: theme.textTheme.bodyLarge?.copyWith(color: MyColor.getAccent1Color()),
                            textAlign: TextAlign.end,
                          ),
                        ),
                      ),
                    ],
                  ),
                ],
              )),
          spaceDown(Dimensions.space16.h),
          CustomAppCard(
              radius: Dimensions.space8,
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  HeaderText(text: MyStrings.supplierPayment.tr),
                  CustomDivider(space: Dimensions.space10),
                  Row(
                    children: [
                      Flexible(
                        flex: 1,
                        child: LabelTextField(
                          labelText: MyStrings.paidAmount.tr,
                          controller: controller.supplierPaidAmountController,
                          onChanged: (value) {
                            // // controller.formData[widget.index].discount = value;
                            // controller.calculateUpdateSalePrice(widget.index);
                          },
                          contentPadding: EdgeInsetsDirectional.symmetric(vertical: Dimensions.space17.h, horizontal: Dimensions.space16.w),
                          textInputType: TextInputType.number,
                          textInputAction: TextInputAction.done,
                          radius: Dimensions.largeRadius,
                          validator: (value) {
                            if (value!.isEmpty) {
                              return MyStrings.fieldErrorMsg.tr;
                            } else {
                              return null;
                            }
                          },
                        ),
                      ),
                      spaceSide(Dimensions.space10),
                      Flexible(
                        child: LabelTextField(
                          labelText: MyStrings.paidDate.tr,
                          controller: controller.paidDateController,
                          isRequired: true,
                          readOnly: true,
                          onTap: () {
                            controller.changeSelectedDateOnlyValue(context);
                          },
                          onChanged: (value) {},
                          contentPadding: EdgeInsetsDirectional.symmetric(vertical: Dimensions.space17.h, horizontal: Dimensions.space16.w),
                          textInputType: TextInputType.text,
                          textInputAction: TextInputAction.done,
                          radius: Dimensions.largeRadius,
                          validator: (value) {
                            if (value!.isEmpty) {
                              return MyStrings.fieldErrorMsg.tr;
                            } else {
                              return null;
                            }
                          },
                        ),
                      ),
                    ],
                  ),
                  spaceDown(Dimensions.space10),
                  Column(
                    children: List.generate(controller.paymentMethodList.length, (index) {
                      return CustomAppCard(
                        onPressed: () {
                          controller.changeSelectedPaymentMethod(index);
                        },
                        margin: EdgeInsets.only(top: 12.h),
                        radius: Dimensions.space12,
                        width: double.infinity,
                        padding: EdgeInsetsDirectional.all(Dimensions.space4),
                        backgroundColor: theme.cardColor,
                        borderColor: controller.paymentMethodCurrentIndex == index ? theme.primaryColor : MyColor.getBorderColor(),
                        child: Row(
                          children: [
                            CustomAppCard(
                                radius: Dimensions.space8,
                                backgroundColor: MyColor.getSectionBackgroundColor(),
                                padding: EdgeInsetsDirectional.all(Dimensions.space12.h),
                                showBorder: false,
                                child: MyAssetImageWidget(
                                  assetPath: controller.paymentMethodList[index].name == "Card" ? MyIcons.cardPayment : MyIcons.cashPayment,
                                  isSvg: true,
                                  height: Dimensions.space24.h,
                                  width: Dimensions.space24.w,
                                )),
                            spaceSide(Dimensions.space8),
                            Expanded(child: Text(controller.paymentMethodList[index].name ?? "", style: theme.textTheme.bodyLarge?.copyWith(color: MyColor.black))),
                          ],
                        ),
                      );
                    }),
                  ),
                  spaceDown(Dimensions.space15),
                  if (controller.paymentAccountsDataList.isNotEmpty) ...[
                    spaceDown(Dimensions.space12),
                    CustomDropDownTextField(
                      selectedValue: controller.paymentAccountsDataList.isNotEmpty ? controller.paymentAccountsDataList.first : null,
                      onChanged: (value) {
                        controller.setSelectedPaymentAccount(value);
                      },
                      labelText: MyStrings.paymentAccount.tr,
                      items: controller.paymentAccountsDataList.map((item) {
                        return DropdownMenuItem(
                          value: item,
                          child: Text(
                            item.accountName ?? "",
                            style: theme.textTheme.bodySmall,
                          ),
                        );
                      }).toList(),
                    ),
                  ],
                  spaceDown(Dimensions.space15),
                  LabelTextField(
                    labelText: MyStrings.paymentNote.tr,
                    maxLines: 5,
                    controller: controller.paymentNoteController,
                    onTap: () {},
                    onChanged: (value) {},
                    contentPadding: EdgeInsetsDirectional.symmetric(vertical: Dimensions.space17.h, horizontal: Dimensions.space16.w),
                    textInputType: TextInputType.text,
                    textInputAction: TextInputAction.done,
                    radius: Dimensions.largeRadius,
                    validator: (value) {
                      if (value!.isEmpty) {
                        return MyStrings.fieldErrorMsg.tr;
                      } else {
                        return null;
                      }
                    },
                  ),
                ],
              )),
          spaceDown(Dimensions.space16.h),
        ],
      );
    });
  }
}
