import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/bottom-sheet/custom_bottom_sheet.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/app/components/text/label_text.dart';
import 'package:ovosale/app/screens/purchase/new_purchase/widgets/new_purchase_form_data.dart';
import 'package:ovosale/app/screens/purchase/new_purchase/widgets/products_data_bottom_sheet.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/purchase/new_purchase_controller.dart';

class NewPurchaseSecondStep extends StatefulWidget {
  const NewPurchaseSecondStep({
    super.key,
  });

  @override
  State<NewPurchaseSecondStep> createState() => _NewPurchaseSecondStepState();
}

class _NewPurchaseSecondStepState extends State<NewPurchaseSecondStep> {
  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<NewPurchaseController>(builder: (controller) {
      return Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          LabelText(
            text: MyStrings.selectProducts.tr,
            textStyle: theme.textTheme.labelMedium?.copyWith(
                fontSize: Dimensions.space15.sp, color: MyColor.black),
          ),
          spaceDown(Dimensions.space8),
          CustomAppCard(
            radius: Dimensions.space10,
            onPressed: () {
              CustomBottomSheet(
                isNeedMargin: false,
                child: const ProductDataBottomSheet(),
              ).customBottomSheet(context);
            },
            child: Row(
              mainAxisSize: MainAxisSize.min,
              children: [
                Expanded(
                  child: Wrap(
                    spacing: Dimensions.space8,
                    runSpacing: Dimensions.space8,
                    children: List.generate(
                      controller.selectedProduct.length,
                      (index) {
                        final products = controller.selectedProduct[index];

                        return CustomAppCard(
                            backgroundColor: MyColor.getPrimaryColor(),
                            radius: Dimensions.space10.h,
                            padding: EdgeInsetsDirectional.symmetric(
                              vertical: Dimensions.space8,
                              horizontal: Dimensions.space10,
                            ),
                            child: Text(products.name ?? "",
                                style: theme.textTheme.bodySmall?.copyWith(
                                  color: MyColor.white,
                                )));
                      },
                    ),
                  ),
                ),
                Icon(
                  Icons.arrow_drop_down,
                  color: MyColor.getBodyTextColor(),
                )
              ],
            ),
          ),
          spaceDown(Dimensions.space16.h),
          ListView.builder(
            physics: NeverScrollableScrollPhysics(),
            itemCount: controller.formData.length,
            shrinkWrap: true,
            itemBuilder: (context, index) {
              return Column(
                children: [
                  spaceDown(Dimensions.space20),
                  Row(
                    children: [
                      Expanded(child: CustomDivider()),
                      Flexible(
                        flex: 4,
                        child: Padding(
                          padding: const EdgeInsets.symmetric(
                              horizontal: Dimensions.space15),
                          child: RichText(
                            textAlign: TextAlign.center,
                            text: TextSpan(
                              style: theme.textTheme
                                  .headlineSmall, // Default text style
                              children: [
                                if (controller.formData[index].productName
                                        .toString() !=
                                    "null") ...[
                                  TextSpan(
                                    text:
                                        "${controller.formData[index].productName}\n",
                                  ),
                                  TextSpan(
                                    text: controller
                                        .formData[index].subTitleVariantText
                                        .toString(),
                                    style: theme.textTheme
                                        .bodyMedium, // Smaller text style
                                  ),
                                ] else
                                  TextSpan(
                                    text: MyStrings.productDetails.tr,
                                  ),
                              ],
                            ),
                          ),
                        ),
                      ),
                      Expanded(child: CustomDivider()),
                    ],
                  ),
                  NewPurchaseFormData(
                    index: index,
                  )
                ],
              );
            },
          ),
          spaceDown(Dimensions.space16.h),
        ],
      );
    });
  }
}
