import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/text-field/custom_drop_down_text_field.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/purchase/new_purchase_controller.dart';
import 'package:ovosale/data/services/shared_pref_service.dart';

class NewPurchaseFormData extends StatefulWidget {
  final int index;

  const NewPurchaseFormData({super.key, required this.index});

  @override
  State<NewPurchaseFormData> createState() => _NewPurchaseFormDataState();
}

class _NewPurchaseFormDataState extends State<NewPurchaseFormData> {
  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<NewPurchaseController>(builder: (controller) {
      var item = controller.formData[widget.index];
      return Column(
        children: [
          Row(
            children: [
              Flexible(
                child: LabelTextField(
                  labelText: MyStrings.quantity.tr,
                  isRequired: true,
                  inputTextStyle: theme.textTheme.bodySmall,
                  controller: item.quantityController,
                  onChanged: (value) {
                    controller.calculateUpdateSalePrice(widget.index);
                  },
                  contentPadding: EdgeInsetsDirectional.symmetric(
                      vertical: Dimensions.space17.h,
                      horizontal: Dimensions.space16.w),
                  textInputType: TextInputType.number,
                  textInputAction: TextInputAction.done,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
              ),
              spaceSide(Dimensions.space10),
              Flexible(
                flex: 1,
                child: LabelTextField(
                  controller: item.basePriceController,
                  labelText: MyStrings.basePrice.tr,
                  isRequired: true,
                  onChanged: (value) {
                    controller.calculateUpdateSalePrice(widget.index);
                  },
                  contentPadding: EdgeInsetsDirectional.symmetric(
                      vertical: Dimensions.space17.h,
                      horizontal: Dimensions.space16.w),
                  textInputType: TextInputType.number,
                  textInputAction: TextInputAction.done,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
              ),
            ],
          ),
          spaceDown(Dimensions.space16.h),
          Row(
            children: [
              Flexible(
                flex: 1,
                child: CustomDropDownTextField(
                  selectedValue: controller.formData[widget.index].taxType ??
                      controller.selectedTaxType,
                  onChanged: (value) {
                    controller.selectedTaxType = value;
                    controller.formData[widget.index].taxType = value;
                    controller.calculateUpdateSalePrice(widget.index);

                    controller.update();
                  },
                  isRequired: false,
                  labelText: MyStrings.taxType.tr,
                  items: controller.taxTypeData.map((item) {
                    return DropdownMenuItem(
                      value: item['name'],
                      child: Text(
                        item['name'] ?? "",
                        style: theme.textTheme.bodyMedium,
                      ),
                    );
                  }).toList(),
                ),
              ),
              spaceSide(Dimensions.space10),
              Flexible(
                flex: 1,
                child: CustomDropDownTextField(
                  selectedValue:
                      controller.formData[widget.index].selectedTax ??
                          "Select Tax",
                  onChanged: (value) {
                    controller.formData[widget.index].selectedTax = value;
                    final selectedItem = controller.taxes.firstWhere(
                      (item) => item.name == value,
                    );
                    controller.formData[widget.index].taxId = selectedItem.id;
                    controller.formData[widget.index].vatPercentage =
                        selectedItem.percentage;

                    controller.selectedTaxId = selectedItem.id.toString();

                    controller.calculateUpdateSalePrice(widget.index);

                    controller.update();
                  },
                  isRequired: false,
                  labelText: MyStrings.tax.tr,
                  items: controller.taxes.map((item) {
                    return DropdownMenuItem(
                      value: item.name,
                      child: Text(
                        "${item.name} ${item.id?.toString() == null ? "" : "${AppConverter.formatNumber(item.percentage ?? "0")}%"} ",
                        style: theme.textTheme.bodyMedium,
                      ),
                    );
                  }).toList(),
                ),
              ),
            ],
          ),
          spaceDown(Dimensions.space16.h),
          Row(
            children: [
              Flexible(
                flex: 1,
                child: LabelTextField(
                  labelText: MyStrings.purchasePrice.tr,
                  controller: item.purchasePriceController,
                  isRequired: true,
                  onChanged: (value) {
                    controller.calculateUpdateSalePrice(widget.index);
                  },
                  contentPadding: EdgeInsetsDirectional.symmetric(
                      vertical: Dimensions.space17.h,
                      horizontal: Dimensions.space16.w),
                  textInputType: TextInputType.number,
                  textInputAction: TextInputAction.done,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
              ),
              spaceSide(Dimensions.space10),
              Flexible(
                flex: 1,
                child: LabelTextField(
                  controller: item.subTotalController,
                  labelText: MyStrings.subTotal.tr,
                  readOnly: true,
                  onChanged: (value) {},
                  contentPadding: EdgeInsetsDirectional.symmetric(
                      vertical: Dimensions.space17.h,
                      horizontal: Dimensions.space16.w),
                  textInputType: TextInputType.number,
                  textInputAction: TextInputAction.done,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
              ),
            ],
          ),
          spaceDown(Dimensions.space16),
          Row(
            children: [
              Flexible(
                flex: 1,
                child: LabelTextField(
                  labelText: MyStrings.profitMargin.tr,
                  isRequired: true,
                  controller: item.profitMarginController,
                  onChanged: (value) {
                    //  controller.formData[widget.index].profitMargin = value;
                    controller.calculateUpdateSalePrice(widget.index);
                  },
                  textInputFormatter: [
                    FilteringTextInputFormatter.digitsOnly, // Allow only digits
                    MaxDigitInputFormatter(maxValue: 100)
                  ],
                  contentPadding: EdgeInsetsDirectional.symmetric(
                      vertical: Dimensions.space17.h,
                      horizontal: Dimensions.space16.w),
                  textInputType: TextInputType.number,
                  textInputAction: TextInputAction.done,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                  suffixIcon: CustomAppCard(
                    margin: EdgeInsetsDirectional.only(end: Dimensions.space4),
                    padding: EdgeInsets.all(Dimensions.space8),
                    radius: Dimensions.largeRadius - 2,
                    child: FittedBox(
                        fit: BoxFit.scaleDown,
                        child: Text(
                          "%",
                          style: theme.textTheme.headlineSmall?.copyWith(
                              fontWeight: FontWeight.normal,
                              color: MyColor.getBodyTextColor()
                                  .withValues(alpha: 0.7)),
                        )),
                  ),
                ),
              ),
              spaceSide(Dimensions.space10),
              Flexible(
                flex: 1,
                child: LabelTextField(
                  labelText: MyStrings.salePrice.tr,
                  isRequired: true,
                  controller: item.salePriceController,
                  onChanged: (value) {
                    controller.calculateUpdateSalePrice(widget.index,
                        isEditingSalePrice: true);
                  },
                  contentPadding: EdgeInsetsDirectional.symmetric(
                      vertical: Dimensions.space17.h,
                      horizontal: Dimensions.space16.w),
                  textInputType: TextInputType.number,
                  textInputAction: TextInputAction.done,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                ),
              ),
            ],
          ),
          spaceDown(Dimensions.space16),
          Row(
            children: [
              Flexible(
                flex: 1,
                child: CustomDropDownTextField(
                  selectedValue:
                      controller.formData[widget.index].discountType ??
                          controller.selectedDiscountType,
                  onChanged: (value) {
                    controller.selectedDiscountType = value;
                    controller.formData[widget.index].discountType = value;

                    controller.calculateUpdateSalePrice(widget.index);
                    controller.update();
                  },
                  isRequired: false,
                  labelText: MyStrings.discount.tr,
                  items: controller.discountTypeData.map((item) {
                    return DropdownMenuItem(
                      value: item["name"],
                      child: Text(
                        item["name"] ?? "",
                        style: theme.textTheme.bodyMedium,
                      ),
                    );
                  }).toList(),
                ),
              ),
              spaceSide(Dimensions.space10),
              Flexible(
                flex: 2,
                child: LabelTextField(
                  labelText: "",
                  isRequired: false,
                  controller: item.saleDiscountController,
                  onChanged: (value) {
                    controller.calculateUpdateSalePrice(widget.index);
                  },
                  contentPadding: EdgeInsetsDirectional.symmetric(
                      vertical: Dimensions.space17.h,
                      horizontal: Dimensions.space16.w),
                  textInputType: TextInputType.number,
                  textInputAction: TextInputAction.done,
                  radius: Dimensions.largeRadius,
                  validator: (value) {
                    if (value!.isEmpty) {
                      return MyStrings.fieldErrorMsg.tr;
                    } else {
                      return null;
                    }
                  },
                  suffixIcon: CustomAppCard(
                    margin: EdgeInsetsDirectional.only(end: Dimensions.space4),
                    padding: EdgeInsets.all(Dimensions.space8),
                    radius: Dimensions.largeRadius - 2,
                    child: FittedBox(
                        fit: BoxFit.scaleDown,
                        child: Text(
                          item.discountType == "Percent"
                              ? "%"
                              : SharedPreferenceService.getCurrencySymbol(),
                          style: theme.textTheme.headlineSmall?.copyWith(
                              fontWeight: FontWeight.normal,
                              color: MyColor.getBodyTextColor()
                                  .withValues(alpha: 0.7)),
                        )),
                  ),
                ),
              ),
            ],
          ),
          spaceDown(Dimensions.space16.h),
          LabelTextField(
            readOnly: true,
            labelText: MyStrings.finalPrice.tr,
            controller: item.finalSalePriceController,
            isRequired: true,
            onChanged: (value) {},
            contentPadding: EdgeInsetsDirectional.symmetric(
                vertical: Dimensions.space17.h,
                horizontal: Dimensions.space16.w),
            textInputType: TextInputType.number,
            textInputAction: TextInputAction.done,
            radius: Dimensions.largeRadius,
            validator: (value) {
              if (value!.isEmpty) {
                return MyStrings.fieldErrorMsg.tr;
              } else {
                return null;
              }
            },
            suffixIcon: CustomAppCard(
              margin: EdgeInsetsDirectional.only(end: Dimensions.space4),
              padding: EdgeInsets.all(Dimensions.space8),
              radius: Dimensions.largeRadius - 2,
              child: FittedBox(
                  fit: BoxFit.scaleDown,
                  child: Text(
                    SharedPreferenceService.getCurrencySymbol(isFullText: true),
                    style: theme.textTheme.headlineSmall?.copyWith(
                        fontWeight: FontWeight.normal,
                        color:
                            MyColor.getBodyTextColor().withValues(alpha: 0.7)),
                  )),
            ),
          ),
        ],
      );
    });
  }
}
