import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/shimmer/new_purchase_shimmer.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/app/components/stepper/custom_stepper.dart';
import 'package:ovosale/app/screens/purchase/new_purchase/widgets/purchase_first_step.dart';
import 'package:ovosale/app/screens/purchase/new_purchase/widgets/purchase_second_step.dart';
import 'package:ovosale/app/screens/purchase/new_purchase/widgets/purchase_third_step.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/purchase/new_purchase_controller.dart';
import 'package:ovosale/data/repo/purchase/new_purchase_repo.dart';

class NewPurchaseScreen extends StatefulWidget {
  const NewPurchaseScreen({super.key});

  @override
  State<NewPurchaseScreen> createState() => _NewPurchaseScreenState();
}

class _NewPurchaseScreenState extends State<NewPurchaseScreen> {
  @override
  void initState() {
    Get.put(NewPurchaseRepo());
    final controller =
        Get.put(NewPurchaseController(newPurchaseRepo: Get.find()));

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.getNewPurchaseData();
    });
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<NewPurchaseController>(
      builder: (controller) => MyCustomScaffold(
        padding: EdgeInsetsDirectional.zero,
        pageTitle: MyStrings.newPurchase.tr,
        body: controller.isLoading
            ? NewPurchaseShimmer()
            : CustomAppCard(
                radius: 0,
                margin: EdgeInsetsDirectional.symmetric(
                    vertical: Dimensions.space10.h),
                showBorder: false,
                child: SingleChildScrollView(
                  child: Column(
                    children: [
                      CustomStepperWidget(
                        hasThreeSteps: true,
                        currentStep: controller.step,
                        onStepChanged: (index) {
                          if (index == 1 || index == 2) {
                            controller.changeStep();
                          }
                        },
                        steps: [
                          CustomStep(
                            title: "",
                            isActive: controller.step == 0,
                            content: NewPurchaseFirstStep(),
                          ),
                          CustomStep(
                            title: "",
                            isActive: controller.step == 1,
                            content: NewPurchaseSecondStep(),
                          ),
                          CustomStep(
                            title: "",
                            isActive: controller.step == 2,
                            content: NewPurchaseThirdStep(),
                          ),
                        ],
                      ),
                      Row(
                        children: [
                          controller.step == 1 || controller.step == 2
                              ? Expanded(
                                  child: CustomElevatedBtn(
                                      bgColor: MyColor.getBodyTextColor(),
                                      text: MyStrings.previous.tr,
                                      onTap: () {
                                        controller.previuousStep();
                                      }),
                                )
                              : SizedBox(),
                          spaceSide(controller.step == 1 || controller.step == 2
                              ? Dimensions.space10
                              : 0),
                          controller.step == 0 || controller.step == 1
                              ? Expanded(
                                  child: CustomElevatedBtn(
                                      text: MyStrings.continues.tr,
                                      onTap: () {
                                        if (controller.supplierId != "") {
                                          if (controller.warehouseId != "") {
                                            controller.changeStep();
                                          } else {
                                            CustomSnackBar.error(errorList: [
                                              MyStrings
                                                  .warehouseNameisRequired.tr
                                            ]);
                                          }
                                        } else {
                                          CustomSnackBar.error(errorList: [
                                            MyStrings.supplierNameisRequired.tr
                                          ]);
                                        }
                                      }),
                                )
                              : Expanded(
                                  child: CustomElevatedBtn(
                                      isLoading: controller.submitLoading,
                                      text: MyStrings.submit.tr,
                                      onTap: () {
                                        controller.submitProductData();
                                      }),
                                ),
                        ],
                      )
                    ],
                  ),
                ),
              ),
      ),
    );
  }
}
