import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/app/components/text-field/custom_drop_down_text_field.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/app/components/text/header_text.dart';
import 'package:ovosale/core/helper/string_format_helper.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/purchase/edit_purchase_controller.dart';

class EditPurchaseThirdStep extends StatefulWidget {
  const EditPurchaseThirdStep({
    super.key,
  });

  @override
  State<EditPurchaseThirdStep> createState() => _EditPurchaseThirdStepState();
}

class _EditPurchaseThirdStepState extends State<EditPurchaseThirdStep> {
  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<EditPurchaseController>(builder: (controller) {
      return Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          CustomAppCard(
              radius: Dimensions.space8,
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  HeaderText(text: MyStrings.purchaseSummery.tr),
                  CustomDivider(space: Dimensions.space10),
                  Row(
                    children: [
                      Flexible(
                        flex: 1,
                        child: CustomDropDownTextField(
                          selectedValue:
                              controller.selectedPurchaseDiscountType,
                          onChanged: (value) {
                            controller.selectedPurchaseDiscountType = value;
                            controller.calculateTotal();
                          },
                          labelText: MyStrings.purchaseDiscount.tr,
                          items: controller.discountTypeData.map((item) {
                            return DropdownMenuItem(
                              value: item["name"],
                              child: Text(item["name"] ?? "",
                                  style: theme.textTheme.bodySmall),
                            );
                          }).toList(),
                        ),
                      ),
                      spaceSide(Dimensions.space10),
                      Flexible(
                        flex: 1,
                        child: LabelTextField(
                          labelText: MyStrings.amount.tr,
                          controller: controller.purchaseDiscountController,
                          onChanged: (value) {
                            controller.calculateTotal();
                          },
                          contentPadding: EdgeInsetsDirectional.symmetric(
                              vertical: Dimensions.space17.h,
                              horizontal: Dimensions.space16.w),
                          textInputType: TextInputType.number,
                          textInputAction: TextInputAction.done,
                          radius: Dimensions.largeRadius,
                          validator: (value) {
                            if (value!.isEmpty) {
                              return MyStrings.fieldErrorMsg.tr;
                            } else {
                              return null;
                            }
                          },
                        ),
                      ),
                    ],
                  ),
                  spaceDown(Dimensions.space16.h),
                  LabelTextField(
                    labelText: MyStrings.shippingAmount.tr,
                    controller: controller.shippingAmountController,
                    onChanged: (value) {
                      controller.calculateTotal();
                    },
                    contentPadding: EdgeInsetsDirectional.symmetric(
                        vertical: Dimensions.space17.h,
                        horizontal: Dimensions.space16.w),
                    textInputType: TextInputType.number,
                    textInputAction: TextInputAction.done,
                    radius: Dimensions.largeRadius,
                    validator: (value) {
                      if (value!.isEmpty) {
                        return MyStrings.fieldErrorMsg.tr;
                      } else {
                        return null;
                      }
                    },
                  ),
                  spaceDown(Dimensions.space15),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Expanded(
                        child: Text(
                          MyStrings.subTotal.tr,
                          style: theme.textTheme.bodyLarge,
                        ),
                      ),
                      Flexible(
                        child: FittedBox(
                          fit: BoxFit.scaleDown,
                          child: Text(
                            "${controller.totalSubTotal.toString()}${controller.defaultCurrency}",
                            style: theme.textTheme.bodyLarge
                                ?.copyWith(color: MyColor.getAccent1Color()),
                          ),
                        ),
                      ),
                    ],
                  ),
                  CustomDivider(
                    space: Dimensions.space5.h,
                  ),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Expanded(
                        child: Text(
                          MyStrings.discountAmount.tr,
                          style: theme.textTheme.bodyLarge,
                        ),
                      ),
                      Flexible(
                        child: FittedBox(
                          fit: BoxFit.scaleDown,
                          child: Text(
                            controller.selectedPurchaseDiscountType == "Percent"
                                ? "${AppConverter.formatNumber(controller.discountAmount.toString())}${controller.defaultCurrency} (${controller.purchaseDiscountController.text}%)"
                                : "${controller.purchaseDiscountController.text} ${controller.defaultCurrency}",
                            style: theme.textTheme.bodyLarge
                                ?.copyWith(color: MyColor.getSuccessColor()),
                          ),
                        ),
                      ),
                    ],
                  ),
                  CustomDivider(
                    space: Dimensions.space5.h,
                  ),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Expanded(
                        child: Text(
                          MyStrings.shippingAmount.tr,
                          style: theme.textTheme.bodyLarge,
                        ),
                      ),
                      Flexible(
                        child: FittedBox(
                          fit: BoxFit.scaleDown,
                          child: Text(
                            "${controller.shippingAmountController.text.toString()}${controller.defaultCurrency}",
                            style: theme.textTheme.bodyLarge
                                ?.copyWith(color: MyColor.getSuccessColor()),
                          ),
                        ),
                      ),
                    ],
                  ),
                  CustomDivider(
                    space: Dimensions.space5.h,
                  ),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Expanded(
                        child: Text(
                          MyStrings.total.tr,
                          style: theme.textTheme.bodyLarge,
                        ),
                      ),
                      Flexible(
                        child: FittedBox(
                          fit: BoxFit.scaleDown,
                          child: Text(
                            "${AppConverter.formatNumber(controller.total.toString())}${controller.defaultCurrency}",
                            style: theme.textTheme.bodyLarge
                                ?.copyWith(color: MyColor.getAccent1Color()),
                            textAlign: TextAlign.end,
                          ),
                        ),
                      ),
                    ],
                  ),
                ],
              )),
          spaceDown(Dimensions.space16.h),
        ],
      );
    });
  }
}
