import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/bottom-sheet/custom_bottom_sheet.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/app/components/text/label_text.dart';
import 'package:ovosale/app/screens/purchase/edit_purchase/widgets/edit_purchase_details_form_section.dart';
import 'package:ovosale/app/screens/purchase/edit_purchase/widgets/edit_purchase_product_data_bottomsheet.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/purchase/edit_purchase_controller.dart';

class EditPurchaseSecondStep extends StatefulWidget {
  const EditPurchaseSecondStep({
    super.key,
  });

  @override
  State<EditPurchaseSecondStep> createState() => _EditPurchaseSecondStepState();
}

class _EditPurchaseSecondStepState extends State<EditPurchaseSecondStep> {
  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<EditPurchaseController>(builder: (controller) {
      return Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          LabelText(
            text: MyStrings.selectProducts.tr,
            textStyle: theme.textTheme.labelMedium?.copyWith(
                fontSize: Dimensions.space15.sp, color: MyColor.black),
          ),
          spaceDown(Dimensions.space8),
          CustomAppCard(
            radius: Dimensions.space10,
            onPressed: () {
              CustomBottomSheet(
                isNeedMargin: false,
                child: const EditPurchaseProductDataBottomSheet(),
              ).customBottomSheet(context);
            },
            child: Row(
              mainAxisSize: MainAxisSize.min,
              children: [
                Expanded(
                  child: Wrap(
                    spacing:
                        Dimensions.space8, // Horizontal spacing between items
                    runSpacing:
                        Dimensions.space8, // Vertical spacing between rows
                    children: List.generate(
                      controller.formData.length,
                      (index) {
                        final products = controller.formData[index];
                        return CustomAppCard(
                            backgroundColor: MyColor.getPrimaryColor(),
                            radius: Dimensions.space10.h,
                            padding: EdgeInsetsDirectional.symmetric(
                              vertical: Dimensions.space8,
                              horizontal: Dimensions.space10,
                            ),
                            child: Text(products.productName ?? "",
                                style: theme.textTheme.bodySmall?.copyWith(
                                  color: MyColor.white,
                                )));
                      },
                    ),
                  ),
                ),
              ],
            ),
          ),
          spaceDown(Dimensions.space16.h),
          ListView.builder(
            physics: NeverScrollableScrollPhysics(),
            itemCount: controller.formData.length,
            shrinkWrap: true,
            itemBuilder: (context, index) {
              return Column(
                children: [
                  spaceDown(Dimensions.space20),
                  Row(
                    children: [
                      Expanded(child: CustomDivider()),
                      Padding(
                        padding: const EdgeInsets.symmetric(
                            horizontal: Dimensions.space15),
                        child: RichText(
                          textAlign: TextAlign.center,
                          text: TextSpan(
                            style: theme
                                .textTheme.headlineSmall, // Default text style
                            children: [
                              if (controller.formData[index].productName
                                      .toString() !=
                                  "null") ...[
                                TextSpan(
                                  text:
                                      "${controller.formData[index].productName}\n",
                                ),
                                TextSpan(
                                  text: controller
                                      .formData[index].subTitleVariantText
                                      .toString(),
                                  style: theme.textTheme
                                      .bodyMedium, // Smaller text style
                                ),
                              ] else
                                TextSpan(
                                  text: MyStrings.productDetails.tr,
                                ),
                            ],
                          ),
                        ),
                      ),
                      Expanded(child: CustomDivider()),
                    ],
                  ),
                  EditPurchaseFormData(
                    index: index,
                  )
                ],
              );
            },
          ),
          spaceDown(Dimensions.space16.h),
        ],
      );
    });
  }
}
