import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/row_widget/bottom_sheet_top_row.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/purchase/edit_purchase_controller.dart';

class EditPurchaseProductDataBottomSheet extends StatefulWidget {
  const EditPurchaseProductDataBottomSheet({super.key});

  @override
  State<EditPurchaseProductDataBottomSheet> createState() =>
      _EditPurchaseProductDataBottomSheetState();
}

class _EditPurchaseProductDataBottomSheetState
    extends State<EditPurchaseProductDataBottomSheet> {
  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<EditPurchaseController>(
      builder: (controller) => SizedBox(
        height: MediaQuery.of(context).size.height,
        child: Column(
          children: [
            BottomSheetTopRow(
              header: MyStrings.products.tr,
              bgColor: MyColor.white,
            ),
            LabelTextField(
              labelText: MyStrings.search.tr,
              hintText: MyStrings.searchProduct.tr,
              onChanged: (value) {
                controller
                    .getProductData(); // Assuming this filters based on search
              },
              controller: controller.productSearchController,
              contentPadding: EdgeInsetsDirectional.symmetric(
                  vertical: Dimensions.space17.h,
                  horizontal: Dimensions.space16.w),
              textInputType: TextInputType.text,
              textInputAction: TextInputAction.done,
              radius: Dimensions.largeRadius,
              validator: (value) {
                if (value!.isEmpty) {
                  return MyStrings.fieldErrorMsg.tr;
                } else {
                  return null;
                }
              },
            ),
            Expanded(
              child: ListView.builder(
                shrinkWrap: true,
                itemCount: controller.productsData.length,
                itemBuilder: (context, index) {
                  final item = controller.productsData[index];
                  bool isSelected = controller.formData.firstWhereOrNull(
                          (element) =>
                              element.variantId == item.original?.variant?.id &&
                              element.productId == item.original?.productId) !=
                      null;
                  int selectedIndex = controller.formData.indexWhere(
                      (element) =>
                          element.variantId == item.original?.variant?.id &&
                          element.productId == item.original?.productId);
                  return CustomAppCard(
                    radius: Dimensions.space10,
                    padding: EdgeInsetsDirectional.symmetric(
                        horizontal: 10, vertical: 20),
                    onPressed: () {
                      printW(selectedIndex);
                      // Update the selected products list
                      controller.updateSelectedProduct(
                        index: selectedIndex,
                        isSelected: isSelected,
                        item,
                        subTitleVariantText:
                            "${item.original?.attribute != null ? item.original?.attribute?.name : ""}${item.original?.variant != null ? "-" : ""}${item.original?.variant != null ? item.original?.variant?.name : ""}",
                      );
                    },
                    margin: const EdgeInsets.symmetric(vertical: 10),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        Expanded(
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Wrap(
                                children: [
                                  Text(item.name ?? ""),
                                  Text(
                                    " ${item.original?.attribute != null ? "-" : ""}${item.original?.attribute != null ? item.original?.attribute?.name : ""}${item.original?.variant != null ? "-" : ""}${item.original?.variant != null ? item.original?.variant?.name : ""}",
                                    style: theme.textTheme.bodyMedium
                                        ?.copyWith(fontWeight: FontWeight.w600),
                                  ),
                                  Text(
                                    "- ${item.original?.product?.productCode ?? ""}",
                                    style: theme.textTheme.bodyMedium
                                        ?.copyWith(fontWeight: FontWeight.w600),
                                  ),
                                ],
                              ),
                            ],
                          ),
                        ),
                        Icon(
                          !isSelected
                              ? Icons.circle_outlined
                              : Icons.check_circle_outline_outlined,
                          color: isSelected
                              ? MyColor.getPrimaryColor()
                              : MyColor.getBodyTextColor(),
                        ),
                      ],
                    ),
                  );
                },
              ),
            ),
          ],
        ),
      ),
    );
  }
}
