import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/pick_image/pick_image.dart';
import 'package:ovosale/app/components/text-field/custom_drop_down_text_field.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/app/components/text/label_text.dart';
import 'package:ovosale/app/screens/brands/new_brand_screen.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/purchase/edit_purchase_controller.dart';

class EDitPurchaseFirstStep extends StatefulWidget {
  const EDitPurchaseFirstStep({
    super.key,
  });

  @override
  State<EDitPurchaseFirstStep> createState() => _EDitPurchaseFirstStepState();
}

class _EDitPurchaseFirstStepState extends State<EDitPurchaseFirstStep> {
  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<EditPurchaseController>(builder: (controller) {
      return Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          LabelTextField(
            labelText: MyStrings.purchaseDate.tr,
            controller: controller.dateController,
            isRequired: true,
            readOnly: true,
            onTap: () {
              controller.changeSelectedDateOnlyValue(context);
            },
            onChanged: (value) {},
            contentPadding: EdgeInsetsDirectional.symmetric(
                vertical: Dimensions.space17.h,
                horizontal: Dimensions.space16.w),
            textInputType: TextInputType.text,
            textInputAction: TextInputAction.done,
            radius: Dimensions.largeRadius,
            validator: (value) {
              if (value!.isEmpty) {
                return MyStrings.fieldErrorMsg.tr;
              } else {
                return null;
              }
            },
          ),
          spaceDown(Dimensions.space16.h),
          CustomDropDownTextField(
            readOnly: true,
            selectedValue: controller.selectedSupplier,
            onChanged: (value) {
              controller.selectedSupplier = value;
              final selectedItem = controller.suppliers.firstWhere(
                (item) => item.name == value,
              );
              controller.supplierId = selectedItem.id.toString();
              controller.update();
            },
            labelText: MyStrings.supplier.tr,
            items: controller.suppliers.map((item) {
              return DropdownMenuItem(
                value: item.name,
                child: Text(item.name!, style: theme.textTheme.bodySmall),
              );
            }).toList(),
          ),
          spaceDown(Dimensions.space16.h),
          CustomDropDownTextField(
            readOnly: true,
            selectedValue: controller.selectedWarehouse,
            onChanged: (value) {
              controller.selectedWarehouse = value;
              final selectedItem = controller.warehouses.firstWhere(
                (item) => item.name == value,
              );
              controller.warehouseId = selectedItem.id.toString();
              controller.update();
            },
            labelText: MyStrings.warehouse.tr,
            items: controller.warehouses.map((item) {
              return DropdownMenuItem(
                value: item.name,
                child: Text(item.name!, style: theme.textTheme.bodySmall),
              );
            }).toList(),
          ),
          spaceDown(Dimensions.space16.h),
          CustomDropDownTextField(
            readOnly:
                controller.selectedStaticStatus.toLowerCase() == "received",
            selectedValue: controller.selectedStatus,
            onChanged: (value) {
              controller.selectedStatus = value;

              //  controller.selectedBrandId = selectedItem.id.toString();
              controller.update();
            },
            labelText: MyStrings.status.tr,
            items: controller.statusData.map((item) {
              return DropdownMenuItem(
                value: item['label'],
                child:
                    Text(item['label'] ?? "", style: theme.textTheme.bodySmall),
              );
            }).toList(),
          ),
          spaceDown(Dimensions.space16.h),
          LabelTextField(
            labelText: MyStrings.referenceNo.tr,
            hintText: MyStrings.referenceNo.tr,
            controller: controller.referenceController,
            onChanged: (value) {},
            contentPadding: EdgeInsetsDirectional.symmetric(
                vertical: Dimensions.space17.h,
                horizontal: Dimensions.space16.w),
            textInputType: TextInputType.text,
            textInputAction: TextInputAction.done,
            radius: Dimensions.largeRadius,
            validator: (value) {
              if (value!.isEmpty) {
                return MyStrings.fieldErrorMsg.tr;
              } else {
                return null;
              }
            },
          ),
          spaceDown(Dimensions.space16.h),
          LabelText(
            text: MyStrings.attachment.tr,
            textStyle: theme.textTheme.labelMedium?.copyWith(
                fontSize: Dimensions.space15.sp, color: MyColor.black),
          ),
          spaceDown(Dimensions.space8.h),
          CustomPaint(
            painter: DottedBorderPainter(),
            child: CustomAppCard(
              onPressed: () {
                controller.pickFile();
              },
              showBorder: false,
              width: double.infinity,
              child: Stack(
                children: [
                  Align(
                    alignment: Alignment.center, // Center the main content
                    child: controller.selectedFile == null
                        ? Column(
                            children: [
                              MyAssetImageWidget(
                                  assetPath: MyIcons.addImage,
                                  isSvg: true,
                                  height: Dimensions.space56.h,
                                  width: Dimensions.space56.w,
                                  color: theme.primaryColor),
                              Text(
                                MyStrings.tapToAddImage.tr,
                                style: theme.textTheme.bodyLarge?.copyWith(
                                  fontSize: Dimensions.space16.sp,
                                ),
                              )
                            ],
                          )
                        : PickImageSection(
                            selectedFile: controller.selectedFile,
                          ),
                  ),
                  if (controller.selectedFile != null)
                    Align(
                      alignment: Alignment
                          .topRight, // Position the button in the top-right
                      child: CustomAppCard(
                        onPressed: () {
                          controller.removeSelectedFile();
                        },
                        showBorder: false,
                        padding: EdgeInsetsDirectional.all(Dimensions.space10),
                        radius: Dimensions.space8,
                        backgroundColor:
                            MyColor.getErrorColor().withValues(alpha: .2),
                        child: MyAssetImageWidget(
                          assetPath: MyIcons.delete,
                          isSvg: true,
                          height: Dimensions.space16.h,
                          width: Dimensions.space16.w,
                        ),
                      ),
                    ),
                ],
              ),
            ),
          ),
          spaceDown(Dimensions.space16.h),
        ],
      );
    });
  }
}
