import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/stepper/custom_stepper.dart';
import 'package:ovosale/app/screens/purchase/edit_purchase/widgets/edit_purchase_first_step.dart';
import 'package:ovosale/app/screens/purchase/edit_purchase/widgets/edit_purchase_second_step.dart';
import 'package:ovosale/app/screens/purchase/edit_purchase/widgets/edit_purchase_third_step.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/purchase/edit_purchase_controller.dart';
import 'package:ovosale/data/repo/purchase/edit_purchase_repo.dart';

import '../../../components/shimmer/new_purchase_shimmer.dart';

class EditPurchaseScreen extends StatefulWidget {
  const EditPurchaseScreen({super.key});

  @override
  State<EditPurchaseScreen> createState() => _EditPurchaseScreenState();
}

class _EditPurchaseScreenState extends State<EditPurchaseScreen> {
  @override
  void initState() {
    Get.put(EditPurchaseRepo());
    final controller =
        Get.put(EditPurchaseController(editPurchaseRepo: Get.find()));
    controller.purcahseId = Get.arguments[0];
    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.getPurchaseData();
    });
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<EditPurchaseController>(
      builder: (controller) => MyCustomScaffold(
        padding: EdgeInsetsDirectional.zero,
        pageTitle: MyStrings.editPurchase.tr,
        body: controller.isLoading
            ? NewPurchaseShimmer()
            : CustomAppCard(
                radius: 0,
                margin: EdgeInsetsDirectional.symmetric(
                    vertical: Dimensions.space10.h),
                showBorder: false,
                child: SingleChildScrollView(
                  child: Column(
                    children: [
                      CustomStepperWidget(
                        hasThreeSteps: true,
                        currentStep: controller.step,
                        onStepChanged: (index) {
                          if (index == 1 || index == 2) {
                            controller.changeStep();
                          }
                        },
                        steps: [
                          CustomStep(
                            title: "",
                            isActive: controller.step == 0,
                            content: EDitPurchaseFirstStep(),
                          ),
                          CustomStep(
                            title: "",
                            isActive: controller.step == 1,
                            content: EditPurchaseSecondStep(),
                          ),
                          CustomStep(
                            title: "",
                            isActive: controller.step == 2,
                            content: EditPurchaseThirdStep(),
                          ),
                        ],
                      ),
                      Row(
                        children: [
                          controller.step == 1 || controller.step == 2
                              ? Expanded(
                                  child: CustomElevatedBtn(
                                      bgColor: MyColor.getBodyTextColor(),
                                      text: MyStrings.previous.tr,
                                      onTap: () {
                                        controller.previousStep();
                                      }),
                                )
                              : SizedBox(),
                          spaceSide(controller.step == 1 || controller.step == 2
                              ? Dimensions.space10
                              : 0),
                          controller.step == 0 || controller.step == 1
                              ? Expanded(
                                  child: CustomElevatedBtn(
                                      text: MyStrings.continues.tr,
                                      onTap: () {
                                        controller.changeStep();
                                      }),
                                )
                              : Expanded(
                                  child: CustomElevatedBtn(
                                      isLoading: controller.submitLoading,
                                      text: MyStrings.submit.tr,
                                      onTap: () {
                                        controller.submitPurchaseEditData();
                                      }),
                                ),
                        ],
                      )
                    ],
                  ),
                ),
              ),
      ),
    );
  }
}
