import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/app/components/image/circle_shape_image.dart';
import 'package:ovosale/app/components/image/my_network_image_widget.dart';
import 'package:ovosale/core/route/route.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/profile/profile_controller.dart';

class ProfileTopSection extends StatefulWidget {
  const ProfileTopSection({super.key});

  @override
  State<ProfileTopSection> createState() => _ProfileTopSectionState();
}

class _ProfileTopSectionState extends State<ProfileTopSection> {
  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<ProfileController>(
      builder: (controller) => Container(
        width: MediaQuery.of(context).size.width,
        padding: const EdgeInsets.symmetric(
            vertical: Dimensions.space15, horizontal: Dimensions.space15),
        decoration: BoxDecoration(
            color: theme.cardColor, borderRadius: BorderRadius.circular(10)),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Center(
              child: CustomAppCard(
                showBorder: false,
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    MyNetworkImageWidget(
                      imageUrl: controller.userImage,
                      height: Dimensions.space60.h,
                      width: Dimensions.space60.w,
                      radius: Dimensions.radiusProMax,
                    ),
                    spaceDown(Dimensions.space15),
                    Text(
                      controller.userName,
                      style: theme.textTheme.bodyLarge
                          ?.copyWith(fontWeight: FontWeight.w600),
                    ),
                    Text(
                      controller.userRole,
                      style: theme.textTheme.bodySmall,
                    ),
                    Text(
                      controller.userMail,
                      style: theme.textTheme.bodySmall,
                    ),
                  ],
                ),
              ),
            ),
            SizedBox(height: Dimensions.space45.h),
            InkWell(
              onTap: () {
                Get.toNamed(RouteHelper.profileEditScreen)?.then((v) {
                  controller.getData();
                });
              },
              child: Row(
                children: [
                  CircleShapeImage(
                    imageColor: MyColor.white,
                    image: MyImages.name,
                    backgroundColor: MyColor.getPrimaryColor(),
                  ),
                  const SizedBox(width: Dimensions.space15),
                  Text(
                    MyStrings.editProfile.tr,
                    style: theme.textTheme.bodySmall,
                  ),
                  Spacer(),
                  Icon(
                    Icons.arrow_forward_ios_rounded,
                    color: MyColor.getBodyTextColor(),
                    size: Dimensions.space15,
                  )
                ],
              ),
            ),
            const CustomDivider(space: Dimensions.space15),
            InkWell(
              onTap: () {
                Get.toNamed(RouteHelper.changePasswordScreen);
              },
              child: Row(
                children: [
                  CircleShapeImage(
                    imageColor: MyColor.white,
                    image: MyImages.changePassword,
                    isSvgImage: true,
                    backgroundColor: MyColor.getPrimaryColor(),
                  ),
                  const SizedBox(width: Dimensions.space15),
                  Text(
                    MyStrings.changePassword.tr,
                    style: theme.textTheme.bodySmall,
                  ),
                  Spacer(),
                  Icon(
                    Icons.arrow_forward_ios_rounded,
                    color: MyColor.getBodyTextColor(),
                    size: Dimensions.space15,
                  )
                ],
              ),
            ),
            spaceDown(Dimensions.space10)
          ],
        ),
      ),
    );
  }
}
