import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/shimmer/profile_shimmer.dart';
import 'package:ovosale/app/screens/profile/widget/profile_top_section.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/controller/profile/profile_controller.dart';
import 'package:ovosale/data/repo/profile/profile_repo.dart';

class ProfileScreen extends StatefulWidget {
  const ProfileScreen({super.key});

  @override
  State<ProfileScreen> createState() => _ProfileScreenState();
}

class _ProfileScreenState extends State<ProfileScreen> {
  @override
  void initState() {
    Get.put(ProfileRepo());
    final controller = Get.put(ProfileController(profileRepo: Get.find()));
    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.getData();
    });
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<ProfileController>(
      builder: (controller) => MyCustomScaffold(
        pageTitle: MyStrings.profile.tr,
        body: controller.loading
            ? const ProfileShimmer()
            : const Align(
                alignment: Alignment.topCenter,
                child: SingleChildScrollView(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      ProfileTopSection(),
                    ],
                  ),
                ),
              ),
      ),
    );
  }
}
