import 'dart:io';
import 'package:flutter/material.dart';
import 'package:ovosale/core/utils/dimensions.dart';

class ProfileWidget extends StatelessWidget {
  final File? selectedFile;
  final String imageUrl;

  const ProfileWidget({
    super.key,
    required this.selectedFile,
    required this.imageUrl,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.all(Dimensions.space5),
      child: ClipRRect(
        borderRadius: BorderRadius.circular(Dimensions.space100),
        child: selectedFile != null
            ? Image.file(
                selectedFile ?? File(""),
                width: 100,
                height: 100,
                fit: BoxFit.cover,
              )
            : (imageUrl.isNotEmpty
                ? Image.network(
                    imageUrl,
                    width: 100,
                    height: 100,
                    fit: BoxFit.cover,
                    errorBuilder: (context, error, stackTrace) {
                      return const Icon(Icons.error);
                    },
                  )
                : const Icon(Icons.person)),
      ),
    );
  }
}
