import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/custom_loader/custom_loader.dart';
import 'package:ovosale/app/components/image/my_asset_widget.dart';
import 'package:ovosale/app/components/text-field/label_text_field.dart';
import 'package:ovosale/app/screens/profile/edit_profile/profile_image.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/profile/edit_profile_controller.dart';
import 'package:ovosale/data/repo/profile/edit_profile_repo.dart';

class EditProfileScreen extends StatefulWidget {
  const EditProfileScreen({super.key});

  @override
  State<EditProfileScreen> createState() => _EditProfileScreenState();
}

class _EditProfileScreenState extends State<EditProfileScreen> {
  @override
  void initState() {
    Get.put(EditProfileRepo());
    final controller =
        Get.put(EditProfileController(editProfileRepo: Get.find()));
    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.getData();
    });
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<EditProfileController>(
      builder: (controller) => MyCustomScaffold(
        pageTitle: MyStrings.editProfile.tr,
        body: controller.loading
            ? const CustomLoader()
            : CustomAppCard(
                showBorder: false,
                borderRadius:
                    BorderRadiusDirectional.circular(Dimensions.space10),
                child: Column(
                  mainAxisSize: MainAxisSize.min,
                  children: [
                    Center(
                      child: Stack(
                        children: [
                          ProfileWidget(
                            selectedFile: controller.imageFile,
                            imageUrl: controller.imageUrl,
                          ),
                          Positioned(
                              bottom: 0,
                              right: 0,
                              child: GestureDetector(
                                onTap: () {
                                  controller.selectImage();
                                },
                                child: CircleAvatar(
                                  maxRadius: Dimensions.space16.h,
                                  backgroundColor: theme.cardColor,
                                  child: CircleAvatar(
                                    maxRadius: Dimensions.space14.h,
                                    backgroundColor: theme.primaryColor,
                                    child: Icon(
                                      Icons.edit,
                                      size: Dimensions.space16.h,
                                    ),
                                  ),
                                ),
                              )),
                        ],
                      ),
                    ),
                    spaceDown(Dimensions.space45),
                    LabelTextField(
                      onChanged: () {},
                      hintText: MyStrings.hintNameOrEmail.tr,
                      controller: controller.usernameController,
                      labelText: MyStrings.fullName.tr,
                      focusNode: controller.usernameFocusNode,
                      nextFocus: controller.emailFocusNode,
                      textInputType: TextInputType.emailAddress,
                      textInputAction: TextInputAction.next,
                      radius: Dimensions.largeRadius,
                      validator: (value) {
                        if (value!.isEmpty) {
                          return MyStrings.fieldErrorMsg.tr;
                        } else {
                          return null;
                        }
                      },
                      prefixIcon: MyAssetImageWidget(
                        width: Dimensions.space20,
                        assetPath: MyIcons.circleUser,
                        color: theme.primaryColor,
                        isSvg: true,
                        height: Dimensions.space20,
                        boxFit: BoxFit.scaleDown,
                      ),
                    ),
                    spaceDown(Dimensions.space20),
                    LabelTextField(
                      onChanged: () {},
                      hintText: MyStrings.hintMail.tr,
                      controller: controller.emailController,
                      labelText: MyStrings.email.tr,
                      focusNode: controller.emailFocusNode,
                      nextFocus: controller.usernameFocusNode,
                      textInputType: TextInputType.emailAddress,
                      textInputAction: TextInputAction.next,
                      radius: Dimensions.largeRadius,
                      validator: (value) {
                        if (value!.isEmpty) {
                          return MyStrings.fieldErrorMsg.tr;
                        } else {
                          return null;
                        }
                      },
                      prefixIcon: MyAssetImageWidget(
                        width: Dimensions.space20,
                        assetPath: MyIcons.circleMail,
                        color: theme.primaryColor,
                        isSvg: true,
                        height: Dimensions.space20,
                        boxFit: BoxFit.scaleDown,
                      ),
                    ),
                    spaceDown(Dimensions.space20),
                    CustomElevatedBtn(
                      isLoading: controller.submitLoading,
                      text: MyStrings.save.tr,
                      onTap: () {
                        controller.submitProfileData();
                      },
                      height: Dimensions.space56.h,
                      radius: Dimensions.largeRadius,
                    ),
                    spaceDown(Dimensions.space20),
                  ],
                ),
              ),
      ),
    );
  }
}
