import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/row_widget/bottom_sheet_top_row.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/new_product/new_product_controller.dart';
import 'package:ovosale/data/model/product/add_new_product_response_model.dart';
import 'package:ovosale/data/model/product/global_attribute_model.dart';
import 'package:ovosale/data/model/product/update_product_data_response_model.dart';

class SelectVariantBottomSheet extends StatefulWidget {
  const SelectVariantBottomSheet({super.key});

  @override
  State<SelectVariantBottomSheet> createState() =>
      _SelectVariantBottomSheetState();
}

class _SelectVariantBottomSheetState extends State<SelectVariantBottomSheet> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<NewProductController>(
      builder: (controller) => Column(
        children: [
          BottomSheetTopRow(
            header: MyStrings.variant.tr,
            bgColor: MyColor.white,
          ),
          ListView.builder(
            physics: NeverScrollableScrollPhysics(),
            shrinkWrap: true,
            itemCount: controller.filteredVariants.length,
            itemBuilder: (context, index) {
              final variants = controller.filteredVariants[index];

              final isSelected =
                  controller.selectedVariantIds?.contains(variants.id ?? "0") ??
                      false;

              final isDisabled = controller.selectedDisabledVariantIds
                      ?.contains(variants.id ?? "0") ??
                  false;

              return CustomAppCard(
                radius: Dimensions.space10,
                padding: EdgeInsetsDirectional.symmetric(
                    horizontal: 10, vertical: 20),
                onPressed: () {
                  if (isDisabled) {
                    return;
                  }
                  setState(() {
                    if (isSelected) {
                      controller.selectedVariantIds?.remove(variants.id ?? "0");

                      controller.formData.removeWhere((item) {
                        final isMatch = item.variantId.toString() ==
                            (variants.id ?? "0").toString();

                        return isMatch;
                      });
                    } else {
                      controller.selectedVariantIds?.add(variants.id ?? "0");
                      String? selectedTax = "";
                      for (ProductDetail details
                          in controller.productDetails?.details ?? []) {
                        selectedTax = controller.updateTaxes
                            .firstWhere(
                              (tax) => tax.id == details.taxId,
                              orElse: () =>
                                  Attribute(id: '0', name: 'Select Tax'),
                            )
                            .name;
                      }
                      controller.formData.add(ProductDetailsFormModel(
                          variantName: variants.name,
                          attributeId: variants.attributeId,
                          variantId: variants.id,
                          selectedTax: selectedTax));
                    }
                  });
                  controller.updateSelectedVariants();
                },
                margin: const EdgeInsets.symmetric(vertical: 10),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Text(variants.name ?? ""),
                    Icon(
                      isSelected
                          ? Icons
                              .check_circle_outline_outlined // Show checked icon when selected
                          : Icons
                              .circle_outlined, // Show empty circle when not selected
                      color: isSelected
                          ? MyColor.getPrimaryColor() // Selected color
                          : MyColor.getBodyTextColor(), // Default color
                    ),
                  ],
                ),
              );
            },
          ),
        ],
      ),
    );
  }
}
