import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/row_widget/bottom_sheet_top_row.dart';
import 'package:ovosale/core/utils/dimensions.dart';
import 'package:ovosale/core/utils/my_color.dart';
import 'package:ovosale/core/utils/my_strings.dart';
import 'package:ovosale/data/controller/new_product/new_product_controller.dart';

class SelectAttributeBottomSheet extends StatefulWidget {
  const SelectAttributeBottomSheet({super.key});

  @override
  State<SelectAttributeBottomSheet> createState() =>
      _SelectAttributeBottomSheetState();
}

class _SelectAttributeBottomSheetState
    extends State<SelectAttributeBottomSheet> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<NewProductController>(
      builder: (controller) => Column(
        children: [
          BottomSheetTopRow(
            header: MyStrings.attribute.tr,
            bgColor: MyColor.white,
          ),
          ListView.builder(
            physics: BouncingScrollPhysics(),
            shrinkWrap: true,
            itemCount: controller.updateAttributes.length,
            itemBuilder: (context, index) {
              final attribute = controller.updateAttributes[index];
              final isSelected = controller.selectedAttributeIds
                      ?.contains(attribute.id ?? "0") ??
                  false;

              final isDisabled = controller.selectedDisabledAttributeIds
                      ?.contains(attribute.id ?? "0") ??
                  false;

              return CustomAppCard(
                radius: Dimensions.space10,
                padding: EdgeInsetsDirectional.symmetric(
                    horizontal: 10, vertical: 20),
                onPressed: () {
                  if (isDisabled) {
                    return;
                  }

                  setState(() {
                    if (isSelected) {
                      // Remove the attribute ID from the selectedAttributeIds list
                      controller.selectedAttributeIds
                          ?.remove(attribute.id ?? "0");

                      // Get the attribute ID
                      final attributeId = attribute.id ?? "0";

                      // Remove all variants associated with this attribute from selectedVariantIds
                      controller.selectedVariantIds?.removeWhere((variantId) {
                        final variant = controller.filteredVariants.firstWhere(
                          (v) => v.id == variantId,
                        );
                        return variant.attributeId == attributeId;
                      });

                      // Remove all formData entries associated with the removed variants
                      controller.formData.removeWhere((item) {
                        // Check if the item's variantId is in the selectedVariantIds list
                        final isVariantSelected = controller.selectedVariantIds
                                ?.contains(item.variantId.toString()) ??
                            false;

                        // Check if the item's attributeId matches the removed attribute
                        final isAttributeMatch =
                            item.attributeId == attributeId;

                        // Remove the item if it is not selected or if it belongs to the removed attribute
                        return !isVariantSelected || isAttributeMatch;
                      });
                    } else {
                      // Add the attribute ID to the selectedAttributeIds list
                      controller.selectedAttributeIds?.add(attribute.id ?? "0");
                    }
                  });

                  // Update the selected attributes and variants
                  controller.updateSelectedAttributes();
                  controller.updateSelectedVariants();
                },
                margin: const EdgeInsets.symmetric(vertical: 10),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Text(attribute.name ?? ""),
                    Icon(
                      isSelected
                          ? Icons
                              .check_circle_outline_outlined // Show checked icon when selected
                          : Icons
                              .circle_outlined, // Show empty circle when not selected
                      color: isSelected
                          ? MyColor.getPrimaryColor() // Selected color
                          : MyColor.getBodyTextColor(), // Default color
                    ),
                  ],
                ),
              );
            },
          ),
        ],
      ),
    );
  }
}
