import 'dart:ui';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/buttons/custom_elevated_button.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/card/my_custom_scaffold.dart';
import 'package:ovosale/app/components/divider/custom_divider.dart';
import 'package:ovosale/app/components/shimmer/new_purchase_shimmer.dart';
import 'package:ovosale/app/components/snack_bar/show_custom_snackbar.dart';
import 'package:ovosale/app/components/stepper/custom_stepper.dart';
import 'package:ovosale/app/screens/products/widgets/update/product_update_first_step.dart';
import 'package:ovosale/app/screens/products/widgets/update/products_update_second_step.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/new_product/new_product_controller.dart';
import 'package:ovosale/data/repo/new_product/new_product_repo.dart';

class UpdateProductScreen extends StatefulWidget {
  const UpdateProductScreen({super.key});

  @override
  State<UpdateProductScreen> createState() => _UpdateProductScreenState();
}

class _UpdateProductScreenState extends State<UpdateProductScreen> {
  @override
  void initState() {
    Get.put(NewProductRepo());
    final controller =
        Get.put(NewProductController(newProductRepo: Get.find()));
    controller.updateProductId = Get.arguments[0];
    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.getUpdateProductData(controller.updateProductId);
    });
  }

  @override
  Widget build(BuildContext context) {
    ThemeData theme = Theme.of(context);
    return GetBuilder<NewProductController>(
      builder: (controller) => MyCustomScaffold(
        padding: EdgeInsetsDirectional.zero,
        pageTitle: MyStrings.updateProduct.tr,
        body: controller.loading
            ? NewPurchaseShimmer()
            : CustomAppCard(
                radius: 0,
                margin: EdgeInsetsDirectional.symmetric(
                    vertical: Dimensions.space10.h),
                showBorder: false,
                child: SingleChildScrollView(
                  child: Column(
                    children: [
                      CustomStepperWidget(
                        currentStep: controller.isStep2 ? 1 : 0,
                        onStepChanged: (index) {
                          if (index == 1 && !controller.isStep2) {
                            controller.stepChanger();
                          }
                        },
                        steps: [
                          CustomStep(
                            title: "",
                            isActive: !controller.isStep2,
                            content: ProductUpdateFirstStep(),
                          ),
                          CustomStep(
                            title: "",
                            isActive: controller.isStep2,
                            content: Column(
                              children: [
                                ListView.builder(
                                  physics: NeverScrollableScrollPhysics(),
                                  itemCount: controller.formData.length,
                                  shrinkWrap: true,
                                  itemBuilder: (context, index) {
                                    return Column(
                                      children: [
                                        Row(
                                          children: [
                                            Expanded(child: CustomDivider()),
                                            Padding(
                                              padding:
                                                  const EdgeInsets.symmetric(
                                                      horizontal:
                                                          Dimensions.space15),
                                              child: Text(
                                                controller.selectedProductType ==
                                                        "Static"
                                                    ? MyStrings
                                                        .productDetails.tr
                                                    : "${controller.formData[index].attributeName.toString() != "null" ? controller.formData[index].attributeName.toString() : ""}"
                                                        "${controller.formData[index].attributeName.toString() == "null" ? "" : "-"}"
                                                        "${controller.formData[index].variantName.toString() != "null" ? controller.formData[index].variantName.toString() : MyStrings.productDetails.tr}",
                                                style: theme
                                                    .textTheme.headlineSmall,
                                              ),
                                            ),
                                            Expanded(child: CustomDivider()),
                                          ],
                                        ),
                                        ProductUpdateSecondStep(index: index),
                                      ],
                                    );
                                  },
                                ),
                                spaceDown(Dimensions.space20),
                                Row(
                                  children: [
                                    Expanded(
                                        child: CustomElevatedBtn(
                                            bgColor: MyColor.getBodyTextColor(),
                                            text: MyStrings.previous.tr,
                                            onTap: () {
                                              controller.stepChanger();
                                            })),
                                    spaceSide(Dimensions.space10),
                                    Expanded(
                                        child: CustomElevatedBtn(
                                            isLoading: controller.submitLoading,
                                            text: MyStrings.update.tr,
                                            onTap: () {
                                              controller
                                                  .submitProductUpdateData();
                                            })),
                                  ],
                                )
                              ],
                            ),
                          ),
                        ],
                      ),
                      controller.isStep2 == false
                          ? CustomElevatedBtn(
                              onTap: () {
                                if (controller.productNameController.text !=
                                    "") {
                                  if (controller.selectedBrandId != "0") {
                                    if (controller.selectedUnitId != "0") {
                                      if (controller.selectedCategoryId !=
                                          "0") {
                                        controller.stepChanger();
                                      } else {
                                        CustomSnackBar.error(errorList: [
                                          MyStrings.categoryNameIsRequired.tr
                                        ]);
                                      }
                                    } else {
                                      CustomSnackBar.error(errorList: [
                                        MyStrings.unitNameIsRequired.tr
                                      ]);
                                    }
                                  } else {
                                    CustomSnackBar.error(errorList: [
                                      MyStrings.brandNameIsRequired.tr
                                    ]);
                                  }
                                } else {
                                  CustomSnackBar.error(errorList: [
                                    MyStrings.productNameIsRequired.tr
                                  ]);
                                }
                              },
                              text: MyStrings.continues.tr,
                            )
                          : const SizedBox()
                    ],
                  ),
                ),
              ),
      ),
    );
  }
}

class DottedBorderPainter extends CustomPainter {
  @override
  void paint(Canvas canvas, Size size) {
    final paint = Paint()
      ..color = MyColor.getPrimaryColor()
      ..strokeWidth = 2
      ..style = PaintingStyle.stroke;

    final double dashWidth = 3; // Width of each dash
    final double dashSpace = 2; // Space between each dash
    final double cornerRadius = 10; // Radius for rounded corners

    final path = Path()
      ..addRRect(RRect.fromRectAndRadius(
          Rect.fromLTWH(0, 0, size.width, size.height),
          Radius.circular(cornerRadius)));

    final PathMetrics pathMetrics = path.computeMetrics();

    for (PathMetric pathMetric in pathMetrics) {
      double distance = 0;
      while (distance < pathMetric.length) {
        final Tangent? tangent = pathMetric.getTangentForOffset(distance);
        if (tangent != null) {
          final Offset start = tangent.position;
          final Offset end = tangent.position +
              Offset(
                  dashWidth * tangent.vector.dx, dashWidth * tangent.vector.dy);
          canvas.drawLine(start, end, paint);
        }
        distance += dashWidth + dashSpace;
      }
    }
  }

  @override
  bool shouldRepaint(CustomPainter oldDelegate) => false;
}
