import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovosale/app/components/card/custom_app_card.dart';
import 'package:ovosale/app/components/row_widget/bottom_sheet_top_row.dart';
import 'package:ovosale/core/utils/util_exporter.dart';
import 'package:ovosale/data/controller/new_product/new_product_controller.dart';

class SelectedAttributeBottomSheet extends StatefulWidget {
  const SelectedAttributeBottomSheet({super.key});

  @override
  State<SelectedAttributeBottomSheet> createState() =>
      _SelectedAttributeBottomSheetState();
}

class _SelectedAttributeBottomSheetState
    extends State<SelectedAttributeBottomSheet> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<NewProductController>(
      builder: (controller) => SizedBox(
        height: MediaQuery.of(context).size.height,
        child: Column(
          children: [
            BottomSheetTopRow(
              header: MyStrings.variant.tr,
              bgColor: MyColor.white,
            ),
            Expanded(
              child: ListView.builder(
                physics: BouncingScrollPhysics(),
                shrinkWrap: true,
                itemCount: controller.attributes.length,
                itemBuilder: (context, index) {
                  final variants = controller.attributes[index];

                  final isSelected = controller.selectedUpdateAttributes
                      .any((variant) => variant.id == variants.id);
                  return CustomAppCard(
                    radius: Dimensions.space10,
                    padding: EdgeInsetsDirectional.symmetric(
                        horizontal: 10, vertical: 20),
                    onPressed: () {
                      if (isSelected) {
                        // Remove the attribute from the selected attributes list
                        controller.selectedUpdateAttributes.removeWhere(
                            (variant) => variant.id == variants.id);

                        // Remove associated variants from the selected variants list
                        controller.selectedVariants.removeWhere(
                            (variant) => variant.attributeId == variants.id);

                        // Remove associated variants from formData
                        controller.formData.removeWhere(
                            (formItem) => formItem.attributeId == variants.id);
                      } else {
                        controller.selectedUpdateAttributes.add(variants);
                      }

                      // Update the selected attribute IDs
                      controller.selectedAttributeIds = controller
                          .selectedUpdateAttributes
                          .map((item) => item.id.toString())
                          .toList();

                      // Filter variants based on selected attributes
                      controller.filterVariantsBySelectedIds(
                          controller.selectedAttributeIds ?? []);

                      controller.update();
                    },
                    margin: const EdgeInsets.symmetric(
                        vertical: Dimensions.space10),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        Expanded(child: Text(variants.name ?? "")),
                        Icon(
                          isSelected
                              ? Icons.check_circle_outline_outlined
                              : Icons.circle_outlined,
                          color: isSelected
                              ? MyColor.getPrimaryColor()
                              : MyColor.getBodyTextColor(),
                        ),
                      ],
                    ),
                  );
                },
              ),
            ),
          ],
        ),
      ),
    );
  }
}
